/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.builtin;

import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.bridge.LocalOfficeContextAware;
import org.aoju.bus.office.builtin.AbstractLocalOffice;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.filter.FilterChain;
import org.aoju.bus.office.magic.filter.RefreshFilter;
import org.aoju.bus.office.provider.SourceDocumentProvider;
import org.aoju.bus.office.provider.TargetDocumentProvider;

public class LocalMadeInOffice
extends AbstractLocalOffice {
    private final TargetDocumentProvider target;
    private final FilterChain filterChain;
    private final Map<String, Object> storeProperties;

    public LocalMadeInOffice(SourceDocumentProvider source, TargetDocumentProvider target, Map<String, Object> loadProperties, FilterChain filterChain, Map<String, Object> storeProperties) {
        super(source, loadProperties);
        this.target = target;
        this.filterChain = Optional.ofNullable(filterChain).map(FilterChain::copy).orElse(RefreshFilter.CHAIN);
        this.storeProperties = storeProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Context context) throws InstrumentException {
        Logger.info("Executing local conversion task...", new Object[0]);
        LocalOfficeContextAware localOfficeContextAware = (LocalOfficeContextAware)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            XComponent document = null;
            try {
                document = this.loadDocument(localOfficeContextAware, sourceFile);
                this.modifyDocument(context, document);
                this.storeDocument(document, targetFile);
                this.target.onComplete(targetFile);
            }
            catch (InstrumentException officeEx) {
                Logger.error("Local conversion failed.", officeEx);
                this.target.onFailure(targetFile, officeEx);
                throw officeEx;
            }
            catch (Exception ex) {
                Logger.error("Local conversion failed.", ex);
                InstrumentException officeEx = new InstrumentException("Local conversion failed", ex);
                this.target.onFailure(targetFile, officeEx);
                throw officeEx;
            }
            finally {
                this.closeDocument(document);
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private Map<String, Object> getStoreProperties(XComponent document) throws InstrumentException {
        HashMap<String, Object> storeProps = new HashMap<String, Object>();
        LocalMadeInOffice.appendProperties(storeProps, this.target.getFormat().getStoreProperties(Builder.getDocumentFamily(document)));
        LocalMadeInOffice.appendProperties(storeProps, this.storeProperties);
        return storeProps;
    }

    protected void modifyDocument(Context context, XComponent document) throws InstrumentException {
        this.filterChain.doFilter(context, document);
    }

    protected void storeDocument(XComponent document, File targetFile) throws InstrumentException {
        Map<String, Object> storeProps = this.getStoreProperties(document);
        try {
            Lo.qi(XStorable.class, document).storeToURL(Builder.toUrl(targetFile), Builder.toUnoProperties(storeProps));
        }
        catch (ErrorCodeIOException errorCodeIoEx) {
            throw new InstrumentException("Could not store document: " + targetFile.getName() + "; errorCode: " + errorCodeIoEx.ErrCode, errorCodeIoEx);
        }
        catch (IOException ioEx) {
            throw new InstrumentException("Could not store document: " + targetFile.getName(), ioEx);
        }
    }
}

