/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.provider;

import java.io.File;
import java.io.InputStream;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.office.Provider;
import org.aoju.bus.office.builtin.AbstractNorm;
import org.aoju.bus.office.builtin.OptionalSource;
import org.aoju.bus.office.magic.family.DefaultFormatRegistry;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.magic.family.FormatRegistry;
import org.aoju.bus.office.metric.InstalledOfficeHolder;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.metric.TemporaryFileMaker;
import org.aoju.bus.office.provider.AbstractSourceProvider;
import org.aoju.bus.office.provider.SourceFromFileProvider;
import org.aoju.bus.office.provider.SourceFromInputStreamProvider;

public abstract class AbstractProvider
implements Provider {
    protected final OfficeManager officeManager;
    protected final FormatRegistry formatRegistry;

    protected AbstractProvider(OfficeManager officeManager, FormatRegistry formatRegistry) {
        OfficeManager manager = officeManager;
        if (null == manager && null == (manager = InstalledOfficeHolder.getInstance())) {
            throw new IllegalStateException("An office manager is required in order to build a converter.");
        }
        this.officeManager = manager;
        this.formatRegistry = null == formatRegistry ? DefaultFormatRegistry.getInstance() : formatRegistry;
    }

    @Override
    public OptionalSource convert(File source) {
        SourceFromFileProvider specs = new SourceFromFileProvider(source);
        DocumentFormat format = this.formatRegistry.getFormatBySuffix(FileKit.getSuffix(source.getName()));
        if (null != format) {
            specs.setDocumentFormat(format);
        }
        return this.convert(specs);
    }

    @Override
    public OptionalSource convert(InputStream source) {
        return this.convert(source, true);
    }

    @Override
    public OptionalSource convert(InputStream source, boolean closeStream) {
        if (this.officeManager instanceof TemporaryFileMaker) {
            return this.convert(new SourceFromInputStreamProvider(source, (TemporaryFileMaker)((Object)this.officeManager), closeStream));
        }
        throw new IllegalStateException("An office manager must implements the TemporaryFileMaker interface in order to be able to convert InputStream");
    }

    protected abstract AbstractNorm convert(AbstractSourceProvider var1);

    @Override
    public FormatRegistry getFormatRegistry() {
        return this.formatRegistry;
    }

    public static abstract class AbstractConverterBuilder<B extends AbstractConverterBuilder<B>> {
        protected OfficeManager officeManager;
        protected FormatRegistry formatRegistry;

        protected AbstractConverterBuilder() {
        }

        public B officeManager(OfficeManager manager) {
            this.officeManager = manager;
            return (B)this;
        }

        public B formatRegistry(FormatRegistry registry) {
            this.formatRegistry = registry;
            return (B)this;
        }

        protected abstract AbstractProvider build();
    }
}

