/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelKit;
import org.aoju.bus.office.support.excel.StyleSet;
import org.aoju.bus.office.support.excel.cell.CellEditor;
import org.aoju.bus.office.support.excel.cell.CellLocation;
import org.aoju.bus.office.support.excel.cell.NullCell;
import org.aoju.bus.office.support.excel.cell.setters.CellSetterFactory;
import org.aoju.bus.office.support.excel.cell.values.ErrorCellValue;
import org.aoju.bus.office.support.excel.cell.values.NumericCellValue;
import org.aoju.bus.office.support.excel.editors.TrimEditor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;

public class CellKit {
    public static Object getCellValue(Cell cell) {
        return CellKit.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return CellKit.getCellValue(cell, cell.getCellType(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        return CellKit.getCellValue(cell, null, cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellKit.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Cell mergedCell;
        if (null == cell) {
            return null;
        }
        if (cell instanceof NullCell) {
            return null == cellEditor ? null : cellEditor.edit(cell, null);
        }
        if (null == cellType) {
            cellType = cell.getCellType();
        }
        if ((mergedCell = CellKit.getMergedRegionCell(cell)) != cell) {
            cell = mergedCell;
            cellType = cell.getCellType();
        }
        Object value = switch (cellType) {
            case CellType.NUMERIC -> new NumericCellValue(cell).getValue();
            case CellType.BOOLEAN -> cell.getBooleanCellValue();
            case CellType.FORMULA -> CellKit.getCellValue(cell, cell.getCachedFormulaResultType(), cellEditor);
            case CellType.BLANK -> "";
            case CellType.ERROR -> new ErrorCellValue(cell).getValue();
            default -> cell.getStringCellValue();
        };
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader) {
        if (null == cell) {
            return;
        }
        if (null != styleSet) {
            cell.setCellStyle(styleSet.getStyleByValueType(value, isHeader));
        }
        CellKit.setCellValue(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style) {
        CellKit.setCellValue(cell, cell1 -> {
            CellKit.setCellValue(cell, value);
            if (null != style) {
                cell1.setCellStyle(style);
            }
        });
    }

    public static void setCellValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (CellType.BLANK != cell.getCellType()) {
            cell.setBlank();
        }
        CellSetterFactory.createCellSetter(value).setValue(cell);
    }

    public static void setComment(Cell cell, String text, String author, ClientAnchor anchor) {
        Sheet sheet = cell.getSheet();
        Workbook wb = sheet.getWorkbook();
        Drawing drawing = sheet.createDrawingPatriarch();
        CreationHelper factory = wb.getCreationHelper();
        if (null == anchor) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
        }
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(text));
        comment.setAuthor(StringKit.nullToEmpty(author));
        cell.setCellComment(comment);
    }

    public static Cell getCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            return new NullCell(row, cellIndex);
        }
        return cell;
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return CellKit.isMergedRegion(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static boolean isMergedRegion(Cell cell) {
        return CellKit.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return true;
            }
        }
        return false;
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return CellKit.getCellRangeAddress(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static CellRangeAddress getCellRangeAddress(Cell cell) {
        return CellKit.getCellRangeAddress(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return ca;
            }
        }
        return null;
    }

    public static void setMergedRegionStyle(Cell cell, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = CellKit.getCellRangeAddress(cell);
        if (cellRangeAddress != null) {
            CellKit.setMergeCellStyle(cellStyle, cellRangeAddress, cell.getSheet());
        }
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        return CellKit.mergingCells(sheet, firstRow, lastRow, firstColumn, lastColumn, null);
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        CellKit.setMergeCellStyle(cellStyle, cellRangeAddress, sheet);
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Object getMergedRegionValue(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelKit.toLocation(locationRef);
        return CellKit.getMergedRegionValue(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static Object getMergedRegionValue(Sheet sheet, int x, int y) {
        return CellKit.getCellValue(SheetUtil.getCell((Sheet)sheet, (int)x, (int)y));
    }

    public static Cell getMergedRegionCell(Cell cell) {
        if (null == cell) {
            return null;
        }
        return ObjectKit.defaultIfNull(CellKit.getMergedCell(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex()), cell);
    }

    public static Cell getMergedRegionCell(Sheet sheet, int x, int y) {
        return ObjectKit.defaultIfNull(CellKit.getMergedCell(sheet, x, y), () -> SheetUtil.getCell((Sheet)sheet, (int)y, (int)x));
    }

    private static Cell getMergedCell(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (!ca.isInRange(y, x)) continue;
            return SheetUtil.getCell((Sheet)sheet, (int)ca.getFirstRow(), (int)ca.getFirstColumn());
        }
        return null;
    }

    private static void setMergeCellStyle(CellStyle cellStyle, CellRangeAddress cellRangeAddress, Sheet sheet) {
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBottomBorderColor((int)cellStyle.getBottomBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
    }
}

