/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.support.excel.sax.CellDataType;
import org.aoju.bus.office.support.excel.sax.Excel03SaxReader;
import org.aoju.bus.office.support.excel.sax.Excel07SaxReader;
import org.aoju.bus.office.support.excel.sax.ExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.RowHandler;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelSaxKit {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    public static ExcelSaxReader<?> createSaxReader(boolean isXlsx, RowHandler rowHandler) {
        return isXlsx ? new Excel07SaxReader(rowHandler) : new Excel03SaxReader(rowHandler);
    }

    public static Object getDataValue(CellDataType cellDataType, String value, SharedStrings sharedStrings, String numFmtString) {
        if (null == value) {
            return null;
        }
        if (null == cellDataType) {
            cellDataType = CellDataType.NULL;
        }
        return switch (cellDataType) {
            case CellDataType.BOOL -> value.charAt(0) != '0';
            case CellDataType.ERROR -> StringKit.format((CharSequence)"\\\"ERROR: {} ", value);
            case CellDataType.FORMULA -> StringKit.format((CharSequence)"\"{}\"", value);
            case CellDataType.INLINESTRING -> new XSSFRichTextString(value).toString();
            case CellDataType.SSTINDEX -> {
                try {
                    int index = Integer.parseInt(value);
                    yield sharedStrings.getItemAt(index).getString();
                }
                catch (NumberFormatException e) {
                    yield value;
                }
            }
            case CellDataType.NUMBER -> {
                try {
                    yield ExcelSaxKit.getNumberValue(value, numFmtString);
                }
                catch (NumberFormatException e) {
                    yield value;
                }
            }
            case CellDataType.DATE -> {
                try {
                    yield ExcelSaxKit.getDateValue(value);
                }
                catch (Exception e) {
                    yield value;
                }
            }
            default -> value;
        };
    }

    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = StringKit.nullToDefault(preRef, "@").replaceAll("\\d+", "");
        String xfd = StringKit.nullToDefault(ref, "@").replaceAll("\\d+", "");
        preXfd = StringKit.fillBefore(preXfd, '@', 3);
        xfd = StringKit.fillBefore(xfd, '@', 3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }

    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws InstrumentException {
        try {
            XMLReader xmlReader = XMLHelper.newXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(xmlDocStream));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InstrumentException(e);
        }
    }

    public static DateTime getDateValue(String value) {
        return ExcelSaxKit.getDateValue(Double.parseDouble(value));
    }

    public static DateTime getDateValue(double value) {
        return DateKit.date(DateUtil.getJavaDate((double)value, (boolean)false));
    }

    public static Object getNumberOrDateValue(CellValueRecordInterface cell, double value, FormatTrackingHSSFListener formatListener) {
        if (Builder.isDateFormat(formatListener.getFormatIndex(cell), formatListener.getFormatString(cell))) {
            return ExcelSaxKit.getDateValue(value);
        }
        return ExcelSaxKit.getNumberValue(value, formatListener.getFormatString(cell));
    }

    private static Number getNumberValue(String value, String numFmtString) {
        if (StringKit.isBlank(value)) {
            return null;
        }
        return ExcelSaxKit.getNumberValue(Double.parseDouble(value), numFmtString);
    }

    private static Number getNumberValue(double numValue, String numFmtString) {
        if (null != numFmtString && !StringKit.contains((CharSequence)numFmtString, ".")) {
            return (long)numValue;
        }
        return numValue;
    }

    public static boolean isDateFormat(Cell cell) {
        return ExcelSaxKit.isDateFormat(cell, null);
    }

    public static boolean isDateFormat(Cell cell, ConditionalFormattingEvaluator cfEvaluator) {
        ExcelNumberFormat nf = ExcelNumberFormat.from((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator);
        return ExcelSaxKit.isDateFormat(nf);
    }

    public static boolean isDateFormat(ExcelNumberFormat numFmt) {
        return ExcelSaxKit.isDateFormat(numFmt.getIdx(), numFmt.getFormat());
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        int[] formats = new int[]{28, 30, 31, 32, 33, 55, 56, 57, 58};
        if (ArrayKit.contains(formats, formatIndex)) {
            return true;
        }
        if (StringKit.isNotEmpty(formatString) && StringKit.containsAny((CharSequence)formatString, "\u5468", "\u661f\u671f", "aa")) {
            return true;
        }
        return DateUtil.isADateFormat((int)formatIndex, (String)formatString);
    }
}

