/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.Dialect;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.dialect.AbstractPaging;
import org.aoju.bus.pager.parser.CountSqlParser;
import org.aoju.bus.pager.plugins.BoundSqlChain;
import org.aoju.bus.pager.plugins.BoundSqlHandler;
import org.aoju.bus.pager.plugins.PageBoundSqlHandler;
import org.aoju.bus.pager.proxy.PageAutoDialect;
import org.aoju.bus.pager.proxy.PageMethod;
import org.aoju.bus.pager.proxy.PageParams;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public class PageContext
extends PageMethod
implements Dialect,
BoundSqlHandler.Chain {
    private PageParams pageParams;
    private PageAutoDialect autoDialect;
    private PageBoundSqlHandler pageBoundSqlHandler;

    @Override
    public boolean skip(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        if (ms.getId().endsWith("_COUNT")) {
            throw new RuntimeException("\u5728\u7cfb\u7edf\u4e2d\u53d1\u73b0\u4e86\u591a\u4e2a\u5206\u9875\u63d2\u4ef6\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e!");
        }
        Page page = this.pageParams.getPage(parameterObject, rowBounds);
        if (page == null) {
            return true;
        }
        if (StringKit.isEmpty(page.getCountColumn())) {
            page.setCountColumn(this.pageParams.getCountColumn());
        }
        this.autoDialect.initDelegateDialect(ms, page.getDialectClass());
        return false;
    }

    @Override
    public boolean beforeCount(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.autoDialect.getDelegate().beforeCount(ms, parameterObject, rowBounds);
    }

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        return this.autoDialect.getDelegate().getCountSql(ms, boundSql, parameterObject, rowBounds, countKey);
    }

    @Override
    public boolean afterCount(long count, Object parameterObject, RowBounds rowBounds) {
        return this.autoDialect.getDelegate().afterCount(count, parameterObject, rowBounds);
    }

    @Override
    public Object processParameterObject(MappedStatement ms, Object parameterObject, BoundSql boundSql, CacheKey pageKey) {
        return this.autoDialect.getDelegate().processParameterObject(ms, parameterObject, boundSql, pageKey);
    }

    @Override
    public boolean beforePage(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.autoDialect.getDelegate().beforePage(ms, parameterObject, rowBounds);
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        return this.autoDialect.getDelegate().getPageSql(ms, boundSql, parameterObject, rowBounds, pageKey);
    }

    public String getPageSql(String sql, Page page, RowBounds rowBounds, CacheKey pageKey) {
        return this.autoDialect.getDelegate().getPageSql(sql, page, pageKey);
    }

    @Override
    public Object afterPage(List pageList, Object parameterObject, RowBounds rowBounds) {
        AbstractPaging delegate = this.autoDialect.getDelegate();
        if (delegate != null) {
            return delegate.afterPage(pageList, parameterObject, rowBounds);
        }
        return pageList;
    }

    @Override
    public void afterAll() {
        AbstractPaging delegate = this.autoDialect.getDelegate();
        if (delegate != null) {
            delegate.afterAll();
            this.autoDialect.clearDelegate();
        }
        PageContext.clearPage();
    }

    @Override
    public BoundSql doBoundSql(BoundSqlHandler.Type type, BoundSql boundSql, CacheKey cacheKey) {
        BoundSqlHandler.Chain chain;
        Page localPage = PageContext.getLocalPage();
        BoundSqlHandler.Chain chain2 = chain = localPage != null ? localPage.getChain() : null;
        if (chain == null) {
            BoundSqlHandler.Chain defaultChain;
            BoundSqlHandler boundSqlHandler = localPage != null ? localPage.getBoundSqlInterceptor() : null;
            BoundSqlHandler.Chain chain3 = defaultChain = this.pageBoundSqlHandler != null ? this.pageBoundSqlHandler.getChain() : null;
            if (boundSqlHandler != null) {
                chain = new BoundSqlChain(defaultChain, Arrays.asList(boundSqlHandler));
            } else if (defaultChain != null) {
                chain = defaultChain;
            }
            if (chain == null) {
                chain = DO_NOTHING;
            }
            if (localPage != null) {
                localPage.setChain(chain);
            }
        }
        return chain.doBoundSql(type, boundSql, cacheKey);
    }

    @Override
    public void setProperties(Properties properties) {
        PageContext.setStaticProperties(properties);
        this.pageParams = new PageParams();
        this.autoDialect = new PageAutoDialect();
        this.pageBoundSqlHandler = new PageBoundSqlHandler();
        this.pageParams.setProperties(properties);
        this.autoDialect.setProperties(properties);
        this.pageBoundSqlHandler.setProperties(properties);
        CountSqlParser.addAggregateFunctions(properties.getProperty("aggregateFunctions"));
    }
}

