/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay;

import com.alipay.api.AlipayClient;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.toolkit.StringKit;

public class Context
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, Context> CFG_MAP = new ConcurrentHashMap<String, Context>();
    private static final String DEFAULT_CFG_KEY = "_default_key_";
    public String appId;
    public String appKey;
    public String appSecret;
    private String mchId;
    private String slAppId;
    private String slMchId;
    private String partnerKey;
    private String apiKey;
    private String apiKey3;
    private String domain;
    private String certPath;
    private String keyPemPath;
    private String certPemPath;
    private Object exParams;
    private String groupMchId;
    private String agentMchId;
    private String serverUrl;
    private String clientId;
    private String secret;
    private boolean sandBox;
    private String rsaPrivateKey;
    private String rsaPublicKey;
    private String desKey;
    private String privateKey;
    private String aliPayPublicKey;
    private String serviceUrl;
    private String charset;
    private String signType;
    private String format;
    private boolean certModel;
    private String appCertPath;
    private String appCertContent;
    private String aliPayCertPath;
    private String aliPayCertContent;
    private String aliPayRootCertPath;
    private String aliPayRootCertContent;
    private AlipayClient alipayClient;

    public static Context putApiConfig(Context context) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, context);
        }
        return CFG_MAP.put(Context.getAppId(), context);
    }

    public static Context setThreadLocalJdPayApiConfig(Context context) {
        if (StringKit.isNotEmpty(Context.getAppId())) {
            Context.setThreadLocalAppId(Context.getAppId());
        }
        return Context.putApiConfig(context);
    }

    public static Context removeApiConfig(Context context) {
        return Context.removeApiConfig(Context.getAppId());
    }

    public static Context removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StringKit.isEmpty(appId)) {
            CFG_MAP.get(DEFAULT_CFG_KEY);
            appId = Context.getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StringKit.isEmpty(appId)) {
            CFG_MAP.get(DEFAULT_CFG_KEY);
            appId = Context.getAppId();
        }
        return appId;
    }

    public static Context getJdPayApiConfig() {
        String appId = Context.getAppId();
        return Context.getApiConfig(appId);
    }

    public static Context getApiConfig(String appId) {
        Context context = CFG_MAP.get(appId);
        if (context == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 Context \u5c06 appId \u5bf9\u5e94\u7684\u914d\u7f6e\u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528\u5176\u4ed6\u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return context;
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getSlAppId() {
        return this.slAppId;
    }

    public String getSlMchId() {
        return this.slMchId;
    }

    public String getPartnerKey() {
        return this.partnerKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiKey3() {
        return this.apiKey3;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getKeyPemPath() {
        return this.keyPemPath;
    }

    public String getCertPemPath() {
        return this.certPemPath;
    }

    public Object getExParams() {
        return this.exParams;
    }

    public String getGroupMchId() {
        return this.groupMchId;
    }

    public String getAgentMchId() {
        return this.agentMchId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean isSandBox() {
        return this.sandBox;
    }

    public String getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public String getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public String getDesKey() {
        return this.desKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getAliPayPublicKey() {
        return this.aliPayPublicKey;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isCertModel() {
        return this.certModel;
    }

    public String getAppCertPath() {
        return this.appCertPath;
    }

    public String getAppCertContent() {
        return this.appCertContent;
    }

    public String getAliPayCertPath() {
        return this.aliPayCertPath;
    }

    public String getAliPayCertContent() {
        return this.aliPayCertContent;
    }

    public String getAliPayRootCertPath() {
        return this.aliPayRootCertPath;
    }

    public String getAliPayRootCertContent() {
        return this.aliPayRootCertContent;
    }

    public AlipayClient getAlipayClient() {
        return this.alipayClient;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setSlAppId(String slAppId) {
        this.slAppId = slAppId;
    }

    public void setSlMchId(String slMchId) {
        this.slMchId = slMchId;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiKey3(String apiKey3) {
        this.apiKey3 = apiKey3;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public void setKeyPemPath(String keyPemPath) {
        this.keyPemPath = keyPemPath;
    }

    public void setCertPemPath(String certPemPath) {
        this.certPemPath = certPemPath;
    }

    public void setExParams(Object exParams) {
        this.exParams = exParams;
    }

    public void setGroupMchId(String groupMchId) {
        this.groupMchId = groupMchId;
    }

    public void setAgentMchId(String agentMchId) {
        this.agentMchId = agentMchId;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setSandBox(boolean sandBox) {
        this.sandBox = sandBox;
    }

    public void setRsaPrivateKey(String rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public void setRsaPublicKey(String rsaPublicKey) {
        this.rsaPublicKey = rsaPublicKey;
    }

    public void setDesKey(String desKey) {
        this.desKey = desKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setAliPayPublicKey(String aliPayPublicKey) {
        this.aliPayPublicKey = aliPayPublicKey;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setCertModel(boolean certModel) {
        this.certModel = certModel;
    }

    public void setAppCertPath(String appCertPath) {
        this.appCertPath = appCertPath;
    }

    public void setAppCertContent(String appCertContent) {
        this.appCertContent = appCertContent;
    }

    public void setAliPayCertPath(String aliPayCertPath) {
        this.aliPayCertPath = aliPayCertPath;
    }

    public void setAliPayCertContent(String aliPayCertContent) {
        this.aliPayCertContent = aliPayCertContent;
    }

    public void setAliPayRootCertPath(String aliPayRootCertPath) {
        this.aliPayRootCertPath = aliPayRootCertPath;
    }

    public void setAliPayRootCertContent(String aliPayRootCertContent) {
        this.aliPayRootCertContent = aliPayRootCertContent;
    }

    public void setAlipayClient(AlipayClient alipayClient) {
        this.alipayClient = alipayClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSandBox() != other.isSandBox()) {
            return false;
        }
        if (this.isCertModel() != other.isCertModel()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$slAppId = this.getSlAppId();
        String other$slAppId = other.getSlAppId();
        if (this$slAppId == null ? other$slAppId != null : !this$slAppId.equals(other$slAppId)) {
            return false;
        }
        String this$slMchId = this.getSlMchId();
        String other$slMchId = other.getSlMchId();
        if (this$slMchId == null ? other$slMchId != null : !this$slMchId.equals(other$slMchId)) {
            return false;
        }
        String this$partnerKey = this.getPartnerKey();
        String other$partnerKey = other.getPartnerKey();
        if (this$partnerKey == null ? other$partnerKey != null : !this$partnerKey.equals(other$partnerKey)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$apiKey3 = this.getApiKey3();
        String other$apiKey3 = other.getApiKey3();
        if (this$apiKey3 == null ? other$apiKey3 != null : !this$apiKey3.equals(other$apiKey3)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$certPath = this.getCertPath();
        String other$certPath = other.getCertPath();
        if (this$certPath == null ? other$certPath != null : !this$certPath.equals(other$certPath)) {
            return false;
        }
        String this$keyPemPath = this.getKeyPemPath();
        String other$keyPemPath = other.getKeyPemPath();
        if (this$keyPemPath == null ? other$keyPemPath != null : !this$keyPemPath.equals(other$keyPemPath)) {
            return false;
        }
        String this$certPemPath = this.getCertPemPath();
        String other$certPemPath = other.getCertPemPath();
        if (this$certPemPath == null ? other$certPemPath != null : !this$certPemPath.equals(other$certPemPath)) {
            return false;
        }
        Object this$exParams = this.getExParams();
        Object other$exParams = other.getExParams();
        if (this$exParams == null ? other$exParams != null : !this$exParams.equals(other$exParams)) {
            return false;
        }
        String this$groupMchId = this.getGroupMchId();
        String other$groupMchId = other.getGroupMchId();
        if (this$groupMchId == null ? other$groupMchId != null : !this$groupMchId.equals(other$groupMchId)) {
            return false;
        }
        String this$agentMchId = this.getAgentMchId();
        String other$agentMchId = other.getAgentMchId();
        if (this$agentMchId == null ? other$agentMchId != null : !this$agentMchId.equals(other$agentMchId)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$rsaPrivateKey = this.getRsaPrivateKey();
        String other$rsaPrivateKey = other.getRsaPrivateKey();
        if (this$rsaPrivateKey == null ? other$rsaPrivateKey != null : !this$rsaPrivateKey.equals(other$rsaPrivateKey)) {
            return false;
        }
        String this$rsaPublicKey = this.getRsaPublicKey();
        String other$rsaPublicKey = other.getRsaPublicKey();
        if (this$rsaPublicKey == null ? other$rsaPublicKey != null : !this$rsaPublicKey.equals(other$rsaPublicKey)) {
            return false;
        }
        String this$desKey = this.getDesKey();
        String other$desKey = other.getDesKey();
        if (this$desKey == null ? other$desKey != null : !this$desKey.equals(other$desKey)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$aliPayPublicKey = this.getAliPayPublicKey();
        String other$aliPayPublicKey = other.getAliPayPublicKey();
        if (this$aliPayPublicKey == null ? other$aliPayPublicKey != null : !this$aliPayPublicKey.equals(other$aliPayPublicKey)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$appCertPath = this.getAppCertPath();
        String other$appCertPath = other.getAppCertPath();
        if (this$appCertPath == null ? other$appCertPath != null : !this$appCertPath.equals(other$appCertPath)) {
            return false;
        }
        String this$appCertContent = this.getAppCertContent();
        String other$appCertContent = other.getAppCertContent();
        if (this$appCertContent == null ? other$appCertContent != null : !this$appCertContent.equals(other$appCertContent)) {
            return false;
        }
        String this$aliPayCertPath = this.getAliPayCertPath();
        String other$aliPayCertPath = other.getAliPayCertPath();
        if (this$aliPayCertPath == null ? other$aliPayCertPath != null : !this$aliPayCertPath.equals(other$aliPayCertPath)) {
            return false;
        }
        String this$aliPayCertContent = this.getAliPayCertContent();
        String other$aliPayCertContent = other.getAliPayCertContent();
        if (this$aliPayCertContent == null ? other$aliPayCertContent != null : !this$aliPayCertContent.equals(other$aliPayCertContent)) {
            return false;
        }
        String this$aliPayRootCertPath = this.getAliPayRootCertPath();
        String other$aliPayRootCertPath = other.getAliPayRootCertPath();
        if (this$aliPayRootCertPath == null ? other$aliPayRootCertPath != null : !this$aliPayRootCertPath.equals(other$aliPayRootCertPath)) {
            return false;
        }
        String this$aliPayRootCertContent = this.getAliPayRootCertContent();
        String other$aliPayRootCertContent = other.getAliPayRootCertContent();
        if (this$aliPayRootCertContent == null ? other$aliPayRootCertContent != null : !this$aliPayRootCertContent.equals(other$aliPayRootCertContent)) {
            return false;
        }
        AlipayClient this$alipayClient = this.getAlipayClient();
        AlipayClient other$alipayClient = other.getAlipayClient();
        return !(this$alipayClient == null ? other$alipayClient != null : !this$alipayClient.equals(other$alipayClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Context;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSandBox() ? 79 : 97);
        result = result * 59 + (this.isCertModel() ? 79 : 97);
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $slAppId = this.getSlAppId();
        result = result * 59 + ($slAppId == null ? 43 : $slAppId.hashCode());
        String $slMchId = this.getSlMchId();
        result = result * 59 + ($slMchId == null ? 43 : $slMchId.hashCode());
        String $partnerKey = this.getPartnerKey();
        result = result * 59 + ($partnerKey == null ? 43 : $partnerKey.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $apiKey3 = this.getApiKey3();
        result = result * 59 + ($apiKey3 == null ? 43 : $apiKey3.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $certPath = this.getCertPath();
        result = result * 59 + ($certPath == null ? 43 : $certPath.hashCode());
        String $keyPemPath = this.getKeyPemPath();
        result = result * 59 + ($keyPemPath == null ? 43 : $keyPemPath.hashCode());
        String $certPemPath = this.getCertPemPath();
        result = result * 59 + ($certPemPath == null ? 43 : $certPemPath.hashCode());
        Object $exParams = this.getExParams();
        result = result * 59 + ($exParams == null ? 43 : $exParams.hashCode());
        String $groupMchId = this.getGroupMchId();
        result = result * 59 + ($groupMchId == null ? 43 : $groupMchId.hashCode());
        String $agentMchId = this.getAgentMchId();
        result = result * 59 + ($agentMchId == null ? 43 : $agentMchId.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $rsaPrivateKey = this.getRsaPrivateKey();
        result = result * 59 + ($rsaPrivateKey == null ? 43 : $rsaPrivateKey.hashCode());
        String $rsaPublicKey = this.getRsaPublicKey();
        result = result * 59 + ($rsaPublicKey == null ? 43 : $rsaPublicKey.hashCode());
        String $desKey = this.getDesKey();
        result = result * 59 + ($desKey == null ? 43 : $desKey.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $aliPayPublicKey = this.getAliPayPublicKey();
        result = result * 59 + ($aliPayPublicKey == null ? 43 : $aliPayPublicKey.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $appCertPath = this.getAppCertPath();
        result = result * 59 + ($appCertPath == null ? 43 : $appCertPath.hashCode());
        String $appCertContent = this.getAppCertContent();
        result = result * 59 + ($appCertContent == null ? 43 : $appCertContent.hashCode());
        String $aliPayCertPath = this.getAliPayCertPath();
        result = result * 59 + ($aliPayCertPath == null ? 43 : $aliPayCertPath.hashCode());
        String $aliPayCertContent = this.getAliPayCertContent();
        result = result * 59 + ($aliPayCertContent == null ? 43 : $aliPayCertContent.hashCode());
        String $aliPayRootCertPath = this.getAliPayRootCertPath();
        result = result * 59 + ($aliPayRootCertPath == null ? 43 : $aliPayRootCertPath.hashCode());
        String $aliPayRootCertContent = this.getAliPayRootCertContent();
        result = result * 59 + ($aliPayRootCertContent == null ? 43 : $aliPayRootCertContent.hashCode());
        AlipayClient $alipayClient = this.getAlipayClient();
        result = result * 59 + ($alipayClient == null ? 43 : $alipayClient.hashCode());
        return result;
    }

    public String toString() {
        return "Context(appId=" + this.getAppId() + ", appKey=" + this.getAppKey() + ", appSecret=" + this.getAppSecret() + ", mchId=" + this.getMchId() + ", slAppId=" + this.getSlAppId() + ", slMchId=" + this.getSlMchId() + ", partnerKey=" + this.getPartnerKey() + ", apiKey=" + this.getApiKey() + ", apiKey3=" + this.getApiKey3() + ", domain=" + this.getDomain() + ", certPath=" + this.getCertPath() + ", keyPemPath=" + this.getKeyPemPath() + ", certPemPath=" + this.getCertPemPath() + ", exParams=" + this.getExParams() + ", groupMchId=" + this.getGroupMchId() + ", agentMchId=" + this.getAgentMchId() + ", serverUrl=" + this.getServerUrl() + ", clientId=" + this.getClientId() + ", secret=" + this.getSecret() + ", sandBox=" + this.isSandBox() + ", rsaPrivateKey=" + this.getRsaPrivateKey() + ", rsaPublicKey=" + this.getRsaPublicKey() + ", desKey=" + this.getDesKey() + ", privateKey=" + this.getPrivateKey() + ", aliPayPublicKey=" + this.getAliPayPublicKey() + ", serviceUrl=" + this.getServiceUrl() + ", charset=" + this.getCharset() + ", signType=" + this.getSignType() + ", format=" + this.getFormat() + ", certModel=" + this.isCertModel() + ", appCertPath=" + this.getAppCertPath() + ", appCertContent=" + this.getAppCertContent() + ", aliPayCertPath=" + this.getAliPayCertPath() + ", aliPayCertContent=" + this.getAliPayCertContent() + ", aliPayRootCertPath=" + this.getAliPayRootCertPath() + ", aliPayRootCertContent=" + this.getAliPayRootCertContent() + ", alipayClient=" + this.getAlipayClient() + ")";
    }

    public Context(String appId, String appKey, String appSecret, String mchId, String slAppId, String slMchId, String partnerKey, String apiKey, String apiKey3, String domain, String certPath, String keyPemPath, String certPemPath, Object exParams, String groupMchId, String agentMchId, String serverUrl, String clientId, String secret, boolean sandBox, String rsaPrivateKey, String rsaPublicKey, String desKey, String privateKey, String aliPayPublicKey, String serviceUrl, String charset, String signType, String format, boolean certModel, String appCertPath, String appCertContent, String aliPayCertPath, String aliPayCertContent, String aliPayRootCertPath, String aliPayRootCertContent, AlipayClient alipayClient) {
        this.appId = appId;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.mchId = mchId;
        this.slAppId = slAppId;
        this.slMchId = slMchId;
        this.partnerKey = partnerKey;
        this.apiKey = apiKey;
        this.apiKey3 = apiKey3;
        this.domain = domain;
        this.certPath = certPath;
        this.keyPemPath = keyPemPath;
        this.certPemPath = certPemPath;
        this.exParams = exParams;
        this.groupMchId = groupMchId;
        this.agentMchId = agentMchId;
        this.serverUrl = serverUrl;
        this.clientId = clientId;
        this.secret = secret;
        this.sandBox = sandBox;
        this.rsaPrivateKey = rsaPrivateKey;
        this.rsaPublicKey = rsaPublicKey;
        this.desKey = desKey;
        this.privateKey = privateKey;
        this.aliPayPublicKey = aliPayPublicKey;
        this.serviceUrl = serviceUrl;
        this.charset = charset;
        this.signType = signType;
        this.format = format;
        this.certModel = certModel;
        this.appCertPath = appCertPath;
        this.appCertContent = appCertContent;
        this.aliPayCertPath = aliPayCertPath;
        this.aliPayCertContent = aliPayCertContent;
        this.aliPayRootCertPath = aliPayRootCertPath;
        this.aliPayRootCertContent = aliPayRootCertContent;
        this.alipayClient = alipayClient;
    }

    public Context() {
    }

    public static class ContextBuilder {
        private String appId;
        private String appKey;
        private String appSecret;
        private String mchId;
        private String slAppId;
        private String slMchId;
        private String partnerKey;
        private String apiKey;
        private String apiKey3;
        private String domain;
        private String certPath;
        private String keyPemPath;
        private String certPemPath;
        private Object exParams;
        private String groupMchId;
        private String agentMchId;
        private String serverUrl;
        private String clientId;
        private String secret;
        private boolean sandBox;
        private String rsaPrivateKey;
        private String rsaPublicKey;
        private String desKey;
        private String privateKey;
        private String aliPayPublicKey;
        private String serviceUrl;
        private String charset;
        private String signType;
        private String format;
        private boolean certModel;
        private String appCertPath;
        private String appCertContent;
        private String aliPayCertPath;
        private String aliPayCertContent;
        private String aliPayRootCertPath;
        private String aliPayRootCertContent;
        private AlipayClient alipayClient;

        ContextBuilder() {
        }

        public ContextBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public ContextBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public ContextBuilder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public ContextBuilder mchId(String mchId) {
            this.mchId = mchId;
            return this;
        }

        public ContextBuilder slAppId(String slAppId) {
            this.slAppId = slAppId;
            return this;
        }

        public ContextBuilder slMchId(String slMchId) {
            this.slMchId = slMchId;
            return this;
        }

        public ContextBuilder partnerKey(String partnerKey) {
            this.partnerKey = partnerKey;
            return this;
        }

        public ContextBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ContextBuilder apiKey3(String apiKey3) {
            this.apiKey3 = apiKey3;
            return this;
        }

        public ContextBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public ContextBuilder certPath(String certPath) {
            this.certPath = certPath;
            return this;
        }

        public ContextBuilder keyPemPath(String keyPemPath) {
            this.keyPemPath = keyPemPath;
            return this;
        }

        public ContextBuilder certPemPath(String certPemPath) {
            this.certPemPath = certPemPath;
            return this;
        }

        public ContextBuilder exParams(Object exParams) {
            this.exParams = exParams;
            return this;
        }

        public ContextBuilder groupMchId(String groupMchId) {
            this.groupMchId = groupMchId;
            return this;
        }

        public ContextBuilder agentMchId(String agentMchId) {
            this.agentMchId = agentMchId;
            return this;
        }

        public ContextBuilder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public ContextBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ContextBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public ContextBuilder sandBox(boolean sandBox) {
            this.sandBox = sandBox;
            return this;
        }

        public ContextBuilder rsaPrivateKey(String rsaPrivateKey) {
            this.rsaPrivateKey = rsaPrivateKey;
            return this;
        }

        public ContextBuilder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public ContextBuilder desKey(String desKey) {
            this.desKey = desKey;
            return this;
        }

        public ContextBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ContextBuilder aliPayPublicKey(String aliPayPublicKey) {
            this.aliPayPublicKey = aliPayPublicKey;
            return this;
        }

        public ContextBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public ContextBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public ContextBuilder signType(String signType) {
            this.signType = signType;
            return this;
        }

        public ContextBuilder format(String format) {
            this.format = format;
            return this;
        }

        public ContextBuilder certModel(boolean certModel) {
            this.certModel = certModel;
            return this;
        }

        public ContextBuilder appCertPath(String appCertPath) {
            this.appCertPath = appCertPath;
            return this;
        }

        public ContextBuilder appCertContent(String appCertContent) {
            this.appCertContent = appCertContent;
            return this;
        }

        public ContextBuilder aliPayCertPath(String aliPayCertPath) {
            this.aliPayCertPath = aliPayCertPath;
            return this;
        }

        public ContextBuilder aliPayCertContent(String aliPayCertContent) {
            this.aliPayCertContent = aliPayCertContent;
            return this;
        }

        public ContextBuilder aliPayRootCertPath(String aliPayRootCertPath) {
            this.aliPayRootCertPath = aliPayRootCertPath;
            return this;
        }

        public ContextBuilder aliPayRootCertContent(String aliPayRootCertContent) {
            this.aliPayRootCertContent = aliPayRootCertContent;
            return this;
        }

        public ContextBuilder alipayClient(AlipayClient alipayClient) {
            this.alipayClient = alipayClient;
            return this;
        }

        public Context build() {
            return new Context(this.appId, this.appKey, this.appSecret, this.mchId, this.slAppId, this.slMchId, this.partnerKey, this.apiKey, this.apiKey3, this.domain, this.certPath, this.keyPemPath, this.certPemPath, this.exParams, this.groupMchId, this.agentMchId, this.serverUrl, this.clientId, this.secret, this.sandBox, this.rsaPrivateKey, this.rsaPublicKey, this.desKey, this.privateKey, this.aliPayPublicKey, this.serviceUrl, this.charset, this.signType, this.format, this.certModel, this.appCertPath, this.appCertContent, this.aliPayCertPath, this.aliPayCertContent, this.aliPayRootCertPath, this.aliPayRootCertContent, this.alipayClient);
        }

        public String toString() {
            return "Context.ContextBuilder(appId=" + this.appId + ", appKey=" + this.appKey + ", appSecret=" + this.appSecret + ", mchId=" + this.mchId + ", slAppId=" + this.slAppId + ", slMchId=" + this.slMchId + ", partnerKey=" + this.partnerKey + ", apiKey=" + this.apiKey + ", apiKey3=" + this.apiKey3 + ", domain=" + this.domain + ", certPath=" + this.certPath + ", keyPemPath=" + this.keyPemPath + ", certPemPath=" + this.certPemPath + ", exParams=" + this.exParams + ", groupMchId=" + this.groupMchId + ", agentMchId=" + this.agentMchId + ", serverUrl=" + this.serverUrl + ", clientId=" + this.clientId + ", secret=" + this.secret + ", sandBox=" + this.sandBox + ", rsaPrivateKey=" + this.rsaPrivateKey + ", rsaPublicKey=" + this.rsaPublicKey + ", desKey=" + this.desKey + ", privateKey=" + this.privateKey + ", aliPayPublicKey=" + this.aliPayPublicKey + ", serviceUrl=" + this.serviceUrl + ", charset=" + this.charset + ", signType=" + this.signType + ", format=" + this.format + ", certModel=" + this.certModel + ", appCertPath=" + this.appCertPath + ", appCertContent=" + this.appCertContent + ", aliPayCertPath=" + this.aliPayCertPath + ", aliPayCertContent=" + this.aliPayCertContent + ", aliPayRootCertPath=" + this.aliPayRootCertPath + ", aliPayRootCertContent=" + this.aliPayRootCertContent + ", alipayClient=" + this.alipayClient + ")";
        }
    }
}

