/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.metric;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.XmlKit;
import org.aoju.bus.pay.Builder;
import org.aoju.bus.pay.Secure;
import org.aoju.bus.pay.magic.Results;

public class WxPayKit {
    private static final String FIELD_SIGN = "sign";
    private static final String FIELD_SIGN_TYPE = "sign_type";

    public static String hmacSha256(String data, String key) {
        return Builder.hmacSha256(data, key);
    }

    public static String md5(String data) {
        return Builder.md5(data);
    }

    public static String decryptData(String base64Data, String key) {
        return Builder.decryptData(base64Data, key);
    }

    public static String encryptData(String data, String key) {
        return Builder.encryptData(data, key);
    }

    public static String generateString() {
        return Builder.generateString();
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey) {
        String sign = params.get(FIELD_SIGN);
        String localSign = WxPayKit.createSign(params, partnerKey, Algorithm.MD5);
        return sign.equals(localSign);
    }

    public static boolean verifyNotify(Map<String, String> params, String partnerKey, Algorithm algorithm) {
        String sign = params.get(FIELD_SIGN);
        String localSign = WxPayKit.createSign(params, partnerKey, algorithm);
        return sign.equals(localSign);
    }

    public static String createSign(Map<String, String> params, String partnerKey, Algorithm algorithm) {
        if (algorithm == null) {
            algorithm = Algorithm.MD5;
        }
        params.remove(FIELD_SIGN);
        String tempStr = Builder.createLinkString(params);
        String stringSignTemp = tempStr + "&key=" + partnerKey;
        if (algorithm == Algorithm.MD5) {
            return WxPayKit.md5(stringSignTemp).toUpperCase();
        }
        return WxPayKit.hmacSha256(stringSignTemp, partnerKey).toUpperCase();
    }

    public static String createSign(Map<String, String> params, String secret) {
        params.remove(FIELD_SIGN);
        String tempStr = Builder.createLinkString(params);
        String stringSignTemp = tempStr + "&secret=" + secret;
        return WxPayKit.md5(stringSignTemp).toUpperCase();
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, Algorithm algorithm) {
        return WxPayKit.buildSign(params, partnerKey, algorithm, true);
    }

    public static Map<String, String> buildSign(Map<String, String> params, String partnerKey, Algorithm algorithm, boolean haveSignType) {
        if (haveSignType) {
            params.put(FIELD_SIGN_TYPE, algorithm.getValue());
        }
        String sign = WxPayKit.createSign(params, partnerKey, algorithm);
        params.put(FIELD_SIGN, sign);
        return params;
    }

    public static StringBuffer forEachMap(Map<String, String> params, String prefix, String suffix) {
        return Builder.forEachMap(params, prefix, suffix);
    }

    public static String toXml(Map<String, String> params) {
        return Builder.toXml(params);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlKit.xmlToMap(xmlStr);
    }

    public static String bizPayUrl(String sign, String appId, String mchId, String productId, String timeStamp, String nonceStr) {
        String rules = "weixin://wxpay/bizpayurl?sign=Temp&appid=Temp&mch_id=Temp&product_id=Temp&time_stamp=Temp&nonce_str=Temp";
        return WxPayKit.replace(rules, "Temp", sign, appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String bizPayUrl(String partnerKey, String appId, String mchId, String productId, String timeStamp, String nonceStr, Algorithm algorithm) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("time_stamp", StringKit.isEmpty(timeStamp) ? Long.toString(System.currentTimeMillis() / 1000L) : timeStamp);
        map.put("nonce_str", StringKit.isEmpty(nonceStr) ? WxPayKit.generateString() : nonceStr);
        map.put("product_id", productId);
        return WxPayKit.bizPayUrl(WxPayKit.createSign(map, partnerKey, algorithm), appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String bizPayUrl(String partnerKey, String appId, String mchId, String productId) {
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonceStr = WxPayKit.generateString();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("appid", appId);
        map.put("mch_id", mchId);
        map.put("time_stamp", timeStamp);
        map.put("nonce_str", nonceStr);
        map.put("product_id", productId);
        return WxPayKit.bizPayUrl(WxPayKit.createSign(map, partnerKey, null), appId, mchId, productId, timeStamp, nonceStr);
    }

    public static String replace(String text, String regex, String ... args) {
        for (String arg : args) {
            text = text.replaceFirst(regex, arg);
        }
        return text;
    }

    public static boolean codeIsOk(String codeValue) {
        return StringKit.isNotEmpty(codeValue) && "SUCCESS".equals(codeValue);
    }

    public static Map<String, String> prepayIdCreateSign(String prepayId, String appId, String partnerKey, Algorithm algorithm) {
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepayId);
        if (algorithm == null) {
            algorithm = Algorithm.MD5;
        }
        packageParams.put("signType", algorithm.getValue());
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, algorithm);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static Map<String, String> jsApiCreateSign(String appId, String prepayId, String keyPath) throws Exception {
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        String packageStr = "prepay_id=" + prepayId;
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", timeStamp);
        packageParams.put("nonceStr", nonceStr);
        packageParams.put("package", packageStr);
        packageParams.put("signType", Algorithm.RSA.toString());
        ArrayList<String> list = new ArrayList<String>();
        list.add(appId);
        list.add(timeStamp);
        list.add(nonceStr);
        list.add(packageStr);
        String packageSign = Builder.createSign(Builder.buildSignMessage(list), keyPath);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static Map<String, String> appPrepayIdCreateSign(String appId, String partnerId, String prepayId, String partnerKey, Algorithm algorithm) {
        HashMap<String, String> packageParams = new HashMap<String, String>(8);
        packageParams.put("appid", appId);
        packageParams.put("partnerid", partnerId);
        packageParams.put("prepayid", prepayId);
        packageParams.put("package", "Sign=WXPay");
        packageParams.put("noncestr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        if (algorithm == null) {
            algorithm = Algorithm.MD5;
        }
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, algorithm);
        packageParams.put(FIELD_SIGN, packageSign);
        return packageParams;
    }

    public static Map<String, String> appCreateSign(String appId, String partnerId, String prepayId, String keyPath) throws Exception {
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> packageParams = new HashMap<String, String>(8);
        packageParams.put("appid", appId);
        packageParams.put("partnerid", partnerId);
        packageParams.put("prepayid", prepayId);
        packageParams.put("package", "Sign=WXPay");
        packageParams.put("timestamp", timeStamp);
        packageParams.put("noncestr", nonceStr);
        packageParams.put("signType", Algorithm.RSA.getValue());
        ArrayList<String> list = new ArrayList<String>();
        list.add(appId);
        list.add(timeStamp);
        list.add(nonceStr);
        list.add(prepayId);
        String packageSign = Builder.createSign(Builder.buildSignMessage(list), keyPath);
        packageParams.put(FIELD_SIGN, packageSign);
        return packageParams;
    }

    public static Map<String, String> miniAppPrepayIdCreateSign(String appId, String prepayId, String partnerKey, Algorithm algorithm) {
        HashMap<String, String> packageParams = new HashMap<String, String>(6);
        packageParams.put("appId", appId);
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepayId);
        if (algorithm == null) {
            algorithm = Algorithm.MD5;
        }
        packageParams.put("signType", algorithm.getValue());
        String packageSign = WxPayKit.createSign(packageParams, partnerKey, algorithm);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static String buildAuthorization(String method, String urlSuffix, String mchId, String serialNo, String keyPath, String body, String nonceStr, long timestamp, String authType) throws Exception {
        String buildSignMessage = Builder.buildSignMessage(method, urlSuffix, timestamp, nonceStr, body);
        String signature = Builder.createSign(buildSignMessage, keyPath);
        return Builder.getAuthorization(mchId, serialNo, nonceStr, String.valueOf(timestamp), signature, authType);
    }

    public static String buildAuthorization(String method, String urlSuffix, String mchId, String serialNo, PrivateKey privateKey, String body, String nonceStr, long timestamp, String authType) throws Exception {
        String buildSignMessage = Builder.buildSignMessage(method, urlSuffix, timestamp, nonceStr, body);
        String signature = Builder.createSign(buildSignMessage, privateKey);
        return Builder.getAuthorization(mchId, serialNo, nonceStr, String.valueOf(timestamp), signature, authType);
    }

    public static String buildAuthorization(String method, String urlSuffix, String mchId, String serialNo, String keyPath, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = Builder.generateString();
        return WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, keyPath, body, nonceStr, timestamp, authType);
    }

    public static String buildAuthorization(String method, String urlSuffix, String mchId, String serialNo, PrivateKey privateKey, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = Builder.generateString();
        return WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, privateKey, body, nonceStr, timestamp, authType);
    }

    @Deprecated
    public static boolean verifySignature(Map<String, Object> map, String certPath) throws Exception {
        String signature = (String)map.get("signature");
        String body = (String)map.get("body");
        String nonceStr = (String)map.get("nonceStr");
        String timestamp = (String)map.get("timestamp");
        return WxPayKit.verifySignature(signature, body, nonceStr, timestamp, FileKit.getInputStream(certPath));
    }

    public static boolean verifySignature(Results response, String certPath) throws Exception {
        String timestamp = response.getHeader("Wechatpay-Timestamp");
        String nonceStr = response.getHeader("Wechatpay-Nonce");
        String signature = response.getHeader("Wechatpay-Signature");
        String body = response.getBody();
        return WxPayKit.verifySignature(signature, body, nonceStr, timestamp, FileKit.getInputStream(certPath));
    }

    public static boolean verifySignature(Results response, InputStream certInputStream) throws Exception {
        String timestamp = response.getHeader("Wechatpay-Timestamp");
        String nonceStr = response.getHeader("Wechatpay-Nonce");
        String signature = response.getHeader("Wechatpay-Signature");
        String body = response.getBody();
        return WxPayKit.verifySignature(signature, body, nonceStr, timestamp, certInputStream);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, String publicKey) throws Exception {
        String buildSignMessage = Builder.buildSignMessage(timestamp, nonce, body);
        return Secure.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, PublicKey publicKey) throws Exception {
        String buildSignMessage = Builder.buildSignMessage(timestamp, nonce, body);
        return Secure.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static boolean verifySignature(String signature, String body, String nonce, String timestamp, InputStream certInputStream) throws Exception {
        String buildSignMessage = Builder.buildSignMessage(timestamp, nonce, body);
        X509Certificate certificate = Builder.getCertificate(certInputStream);
        PublicKey publicKey = certificate.getPublicKey();
        return Secure.checkByPublicKey(buildSignMessage, signature, publicKey);
    }

    public static String verifyNotify(String serialNo, String body, String signature, String nonce, String timestamp, String key, InputStream certInputStream) throws Exception {
        X509Certificate certificate = Builder.getCertificate(certInputStream);
        String serialNumber = certificate.getSerialNumber().toString(16).toUpperCase();
        System.out.println(serialNumber);
        if (serialNumber.equals(serialNo)) {
            boolean verifySignature = WxPayKit.verifySignature(signature, body, nonce, timestamp, certificate.getPublicKey());
            if (verifySignature) {
                JSONObject resultObject = JSON.parseObject((String)body);
                JSONObject resource = resultObject.getJSONObject("resource");
                String cipherText = resource.getString("ciphertext");
                String nonceStr = resource.getString("nonce");
                String associatedData = resource.getString("associated_data");
                Secure secure = new Secure(key.getBytes(Charset.UTF_8));
                return secure.decryptToString(associatedData.getBytes(Charset.UTF_8), nonceStr.getBytes(Charset.UTF_8), cipherText);
            }
            throw new Exception("\u7b7e\u540d\u9519\u8bef");
        }
        throw new Exception("\u8bc1\u4e66\u5e8f\u5217\u53f7\u9519\u8bef");
    }

    public static String verifyNotify(String serialNo, String body, String signature, String nonce, String timestamp, String key, String certPath) throws Exception {
        BufferedInputStream inputStream = FileKit.getInputStream(certPath);
        return WxPayKit.verifyNotify(serialNo, body, signature, nonce, timestamp, key, inputStream);
    }
}

