/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.sensitive;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.ThreadKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.sensitive.Provider;
import org.aoju.bus.sensitive.WordTree;

public final class Builder {
    public static final String ALL = "ALL";
    public static final String SENS = "SENS";
    public static final String SAFE = "SAFE";
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    public static final String NOTHING = "NOTHING";
    public static final String OVERALL = "OVERALL";
    private static final WordTree sensitiveTree = new WordTree();

    public static <T> T on(Object object) {
        return Builder.on(object, null, false);
    }

    public static <T> T on(Object object, boolean clone) {
        return Builder.on(object, null, clone);
    }

    public static <T> T on(Object object, Annotation annotation) {
        return (T)Instances.singletion(Provider.class).on(object, annotation, false);
    }

    public static String json(Object object) {
        return Instances.singletion(Provider.class).json(object, null);
    }

    public static <T> T on(Object object, Annotation annotation, boolean clone) {
        return (T)Instances.singletion(Provider.class).on(object, annotation, clone);
    }

    public static boolean isInited() {
        return !sensitiveTree.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadKit.execAsync(() -> {
                Builder.init(sensitiveWords);
                return true;
            });
        } else {
            Builder.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StringKit.isNotBlank(sensitiveWords)) {
            Builder.init(StringKit.split((CharSequence)sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        Builder.init(sensitiveWords, ',', isAsync);
    }

    public static void setCharFilter(Predicate<Character> charFilter) {
        if (null != charFilter) {
            sensitiveTree.setCharFilter(charFilter);
        }
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static boolean containsSensitive(Object object) {
        return sensitiveTree.isMatch(JsonKit.toJsonString(object));
    }

    public static String getFindedFirstSensitive(String text) {
        return sensitiveTree.match(text);
    }

    public static String getFindedFirstSensitive(Object object) {
        return sensitiveTree.match(JsonKit.toJsonString(object));
    }

    public static List<String> getFindedAllSensitive(String text) {
        return sensitiveTree.matchAll(text);
    }

    public static List<String> getFindedAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAll(text, -1, isDensityMatch, isGreedMatch);
    }

    public static List<String> getFindedAllSensitive(Object bean) {
        return sensitiveTree.matchAll(JsonKit.toJsonString(bean));
    }

    public static List<String> getFindedAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        return Builder.getFindedAllSensitive(JsonKit.toJsonString(bean), isDensityMatch, isGreedMatch);
    }

    public static enum Type {
        NONE,
        DEFAUL,
        NAME,
        CITIZENID,
        PHONE,
        MOBILE,
        ADDRESS,
        EMAIL,
        BANK_CARD,
        CNAPS_CODE,
        PAY_SIGN_NO,
        PASSWORD,
        GENERIC;

    }

    public static enum Mode {
        HEAD,
        TAIL,
        MIDDLE;

    }
}

