/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.handler.ChannelSocketHandler;
import org.aoju.bus.socket.handler.CompletionAcceptHandler;

public class NioQuickServer
implements Closeable {
    private static final CompletionAcceptHandler ACCEPT_HANDLER = new CompletionAcceptHandler();
    private Selector selector;
    private ServerSocketChannel serverSocketChannel;
    private ChannelSocketHandler handler;

    public NioQuickServer(int port) {
        this.init(new InetSocketAddress(port));
    }

    public NioQuickServer init(InetSocketAddress address) {
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.bind(address);
            this.selector = Selector.open();
            this.serverSocketChannel.register(this.selector, 16);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        Logger.debug("Server listen on: [{}]...", address);
        return this;
    }

    public NioQuickServer setChannelHandler(ChannelSocketHandler handler) {
        this.handler = handler;
        return this;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void start() {
        this.listen();
    }

    public void listen() {
        try {
            this.doListen();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private void doListen() throws IOException {
        while (this.selector.isOpen() && 0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    private void handle(SelectionKey key) {
        if (key.isAcceptable()) {
            ACCEPT_HANDLER.completed((ServerSocketChannel)key.channel(), this);
        }
        if (key.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                this.handler.handle(socketChannel);
            }
            catch (Exception e) {
                IoKit.close(socketChannel);
                Logger.error(e);
            }
        }
    }

    @Override
    public void close() {
        IoKit.close(this.selector);
        IoKit.close(this.serverSocketChannel);
    }
}

