/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.spring.banner.BusBanner;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class GenieBuilder
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final MapPropertySource HIGH_PRIORITY_CONFIG = new MapPropertySource("BusHighPriorityConfig", new HashMap());

    public static boolean filterAllLogConfig(String key) {
        return key.startsWith("logging.level.") || key.startsWith("logging.path.") || key.startsWith("logging.config.") || key.equals("logging.path") || key.equals("loggingRoot") || key.equals("file.encoding");
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        SpringApplication application = event.getSpringApplication();
        StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
        StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(source -> !(source instanceof PropertySource.StubPropertySource)).forEach(source -> bootstrapEnvironment.getPropertySources().addLast(source));
        ArrayList sources = new ArrayList();
        for (Object s : application.getAllSources()) {
            if (s instanceof Class) {
                sources.add((Class)s);
                continue;
            }
            if (!(s instanceof String)) continue;
            sources.add(ClassKit.resolveClassName((String)s, null));
        }
        SpringApplication bootstrapApplication = new SpringApplicationBuilder(new Class[0]).profiles(environment.getActiveProfiles()).environment((ConfigurableEnvironment)bootstrapEnvironment).sources(sources.toArray(new Class[0])).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE).listeners(new ApplicationListener[0]).initializers(new ApplicationContextInitializer[0]).build(event.getArgs());
        ApplicationEnvironmentPreparedEvent bootstrapEvent = new ApplicationEnvironmentPreparedEvent(event.getBootstrapContext(), bootstrapApplication, event.getArgs(), (ConfigurableEnvironment)bootstrapEnvironment);
        application.getListeners().stream().filter(listener -> listener instanceof ConfigFileApplicationListener).forEach(listener -> ((ConfigFileApplicationListener)listener).onApplicationEvent((ApplicationEvent)bootstrapEvent));
        application.setBanner((Banner)new BusBanner());
        this.setLogging((ConfigurableEnvironment)bootstrapEnvironment);
        this.setRequireProperties((ConfigurableEnvironment)bootstrapEnvironment);
        this.setEnvironment(environment);
        AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.DETECT);
        AnsiOutput.setConsoleAvailable((Boolean)true);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void setLogging(ConfigurableEnvironment environment) {
        StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(propertySource -> propertySource instanceof EnumerablePropertySource).map(propertySource -> Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames())).flatMap(Collection::stream).filter(GenieBuilder::filterAllLogConfig).forEach(key -> ((Map)HIGH_PRIORITY_CONFIG.getSource()).put(key, environment.getProperty(key)));
    }

    private void setRequireProperties(ConfigurableEnvironment environment) {
        if (StringKit.hasText(environment.getProperty("spring.application.name"))) {
            ((Map)HIGH_PRIORITY_CONFIG.getSource()).put("spring.application.name", environment.getProperty("spring.application.name"));
        }
    }

    private void setEnvironment(ConfigurableEnvironment environment) {
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("BusBootstrap", new HashMap()));
    }
}

