/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.builder.Different;
import org.aoju.bus.core.builder.DifferentResult;
import org.aoju.bus.core.builder.ToStringStyle;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;

public class DifferentBuilder
implements Builder<DifferentResult> {
    private final List<Different<?>> differents;
    private final boolean objectsTriviallyEqual;
    private final Object left;
    private final Object right;
    private final ToStringStyle style;

    public DifferentBuilder(Object lhs, Object rhs, ToStringStyle style, boolean testTriviallyEqual) {
        Assert.isTrue(null != lhs, "lhs cannot be null", new Object[0]);
        Assert.isTrue(null != rhs, "rhs cannot be null", new Object[0]);
        this.differents = new ArrayList();
        this.left = lhs;
        this.right = rhs;
        this.style = style;
        this.objectsTriviallyEqual = testTriviallyEqual && (lhs == rhs || lhs.equals(rhs));
    }

    public DifferentBuilder(Object lhs, Object rhs, ToStringStyle style) {
        this(lhs, rhs, style, true);
    }

    public DifferentBuilder append(String fieldName, final boolean lhs, final boolean rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.differents.add(new Different<Boolean>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Boolean getLeft() {
                    return lhs;
                }

                @Override
                public Boolean getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final boolean[] lhs, final boolean[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Boolean[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Boolean[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Boolean[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final byte lhs, final byte rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.differents.add(new Different<Byte>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Byte getLeft() {
                    return lhs;
                }

                @Override
                public Byte getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final byte[] lhs, final byte[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Byte[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Byte[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Byte[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final char lhs, final char rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.differents.add(new Different<Character>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Character getLeft() {
                    return Character.valueOf(lhs);
                }

                @Override
                public Character getRight() {
                    return Character.valueOf(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final char[] lhs, final char[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Character[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Character[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Character[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final double lhs, final double rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(lhs) != Double.doubleToLongBits(rhs)) {
            this.differents.add(new Different<Double>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Double getLeft() {
                    return lhs;
                }

                @Override
                public Double getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final double[] lhs, final double[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Double[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Double[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Double[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final float lhs, final float rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(lhs) != Float.floatToIntBits(rhs)) {
            this.differents.add(new Different<Float>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Float getLeft() {
                    return Float.valueOf(lhs);
                }

                @Override
                public Float getRight() {
                    return Float.valueOf(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final float[] lhs, final float[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Float[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Float[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Float[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final int lhs, final int rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.differents.add(new Different<Integer>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Integer getLeft() {
                    return lhs;
                }

                @Override
                public Integer getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final int[] lhs, final int[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Integer[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Integer[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Integer[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final long lhs, final long rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.differents.add(new Different<Long>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Long getLeft() {
                    return lhs;
                }

                @Override
                public Long getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final long[] lhs, final long[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Long[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Long[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Long[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final short lhs, final short rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.differents.add(new Different<Short>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Short getLeft() {
                    return lhs;
                }

                @Override
                public Short getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final short[] lhs, final short[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Short[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Short[] getLeft() {
                    return ArrayKit.toObject(lhs);
                }

                @Override
                public Short[] getRight() {
                    return ArrayKit.toObject(rhs);
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, final Object lhs, final Object rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        Object objectToTest = null != lhs ? lhs : rhs;
        if (objectToTest.getClass().isArray()) {
            if (objectToTest instanceof boolean[]) {
                return this.append(fieldName, (boolean[])lhs, (boolean[])rhs);
            }
            if (objectToTest instanceof byte[]) {
                return this.append(fieldName, (byte[])lhs, (byte[])rhs);
            }
            if (objectToTest instanceof char[]) {
                return this.append(fieldName, (char[])lhs, (char[])rhs);
            }
            if (objectToTest instanceof double[]) {
                return this.append(fieldName, (double[])lhs, (double[])rhs);
            }
            if (objectToTest instanceof float[]) {
                return this.append(fieldName, (float[])lhs, (float[])rhs);
            }
            if (objectToTest instanceof int[]) {
                return this.append(fieldName, (int[])lhs, (int[])rhs);
            }
            if (objectToTest instanceof long[]) {
                return this.append(fieldName, (long[])lhs, (long[])rhs);
            }
            if (objectToTest instanceof short[]) {
                return this.append(fieldName, (short[])lhs, (short[])rhs);
            }
            return this.append(fieldName, (Object[])lhs, (Object[])rhs);
        }
        if (null != lhs && lhs.equals(rhs)) {
            return this;
        }
        this.differents.add(new Different<Object>(fieldName){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getLeft() {
                return lhs;
            }

            @Override
            public Object getRight() {
                return rhs;
            }
        });
        return this;
    }

    public DifferentBuilder append(String fieldName, final Object[] lhs, final Object[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.differents.add(new Different<Object[]>(fieldName){
                private static final long serialVersionUID = 1L;

                @Override
                public Object[] getLeft() {
                    return lhs;
                }

                @Override
                public Object[] getRight() {
                    return rhs;
                }
            });
        }
        return this;
    }

    public DifferentBuilder append(String fieldName, DifferentResult differentResult) {
        this.validateFieldNameNotNull(fieldName);
        Assert.isTrue(null != differentResult, "Diff result cannot be null", new Object[0]);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        for (Different<?> different : differentResult.getDifferents()) {
            this.append(fieldName + "." + different.getFieldName(), different.getLeft(), different.getRight());
        }
        return this;
    }

    @Override
    public DifferentResult build() {
        return new DifferentResult(this.left, this.right, this.differents, this.style);
    }

    private void validateFieldNameNotNull(String fieldName) {
        Assert.isTrue(null != fieldName, "Field name cannot be null", new Object[0]);
    }
}

