/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.ansi;

import org.aoju.bus.core.lang.ansi.AnsiColor;
import org.aoju.bus.core.lang.ansi.AnsiElement;

public abstract class AnsiEncoder {
    private static final String ENCODE_JOIN = ";";
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_END = "m";
    private static final String RESET = "0;" + AnsiColor.DEFAULT;

    public static String encode(Object ... args) {
        StringBuilder sb = new StringBuilder();
        AnsiEncoder.buildEnabled(sb, args);
        return sb.toString();
    }

    private static void buildEnabled(StringBuilder sb, Object[] args) {
        boolean writingAnsi = false;
        boolean containsEncoding = false;
        for (Object element : args) {
            if (null == element) continue;
            if (element instanceof AnsiElement) {
                containsEncoding = true;
                if (writingAnsi) {
                    sb.append(ENCODE_JOIN);
                } else {
                    sb.append(ENCODE_START);
                    writingAnsi = true;
                }
            } else if (writingAnsi) {
                sb.append(ENCODE_END);
                writingAnsi = false;
            }
            sb.append(element);
        }
        if (containsEncoding) {
            sb.append(writingAnsi ? ENCODE_JOIN : ENCODE_START);
            sb.append(RESET);
            sb.append(ENCODE_END);
        }
    }
}

