/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.tuple;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.builder.CompareBuilder;
import org.aoju.bus.core.lang.tuple.ImmutablePair;

@ThreadSafe
public abstract class Pair<L, R>
implements Map.Entry<L, R>,
Comparable<Pair<L, R>>,
Serializable {
    public static <L, R> Pair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    public abstract L getLeft();

    public abstract R getRight();

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    @Override
    public R getValue() {
        return this.getRight();
    }

    @Override
    public int compareTo(Pair<L, R> other) {
        return new CompareBuilder().append(this.getLeft(), other.getLeft()).append(this.getRight(), other.getRight()).toComparison();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)object;
            return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (null == this.getKey() ? 0 : this.getKey().hashCode()) ^ (null == this.getValue() ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return "(" + this.getLeft() + "," + this.getRight() + ")";
    }

    public String toString(String format) {
        return String.format(format, this.getLeft(), this.getRight());
    }
}

