/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.scanner.CacheableProcessor;
import org.aoju.bus.core.scanner.Synthesized;
import org.aoju.bus.core.scanner.SynthesizedProcessor;
import org.aoju.bus.core.scanner.SynthesizedSelector;
import org.aoju.bus.core.scanner.Synthetic;
import org.aoju.bus.core.scanner.SyntheticProxy;
import org.aoju.bus.core.scanner.annotation.MetaScanner;
import org.aoju.bus.core.toolkit.AnnoKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class SyntheticMeta
implements Synthetic {
    private final Annotation source;
    private final Map<Class<? extends Annotation>, Synthesized> metaAnnotationMap;
    private final SynthesizedSelector annotationSelector;
    private final SynthesizedProcessor attributeProcessor;

    public SyntheticMeta(Annotation source) {
        this(source, SynthesizedSelector.NEAREST_AND_OLDEST_PRIORITY, new CacheableProcessor(Comparator.comparing(Synthesized::getVerticalDistance).thenComparing(Synthesized::getHorizontalDistance)));
    }

    public SyntheticMeta(Annotation annotation, SynthesizedSelector annotationSelector, SynthesizedProcessor attributeProcessor) {
        Assert.notNull(annotation, "annotation must not null", new Object[0]);
        Assert.notNull(annotationSelector, "annotationSelector must not null", new Object[0]);
        Assert.notNull(attributeProcessor, "attributeProcessor must not null", new Object[0]);
        this.source = annotation;
        this.annotationSelector = annotationSelector;
        this.attributeProcessor = attributeProcessor;
        this.metaAnnotationMap = new LinkedHashMap<Class<? extends Annotation>, Synthesized>();
        this.loadMetaAnnotations();
    }

    public Annotation getSource() {
        return this.source;
    }

    Map<Class<? extends Annotation>, Synthesized> getMetaAnnotationMap() {
        return this.metaAnnotationMap;
    }

    @Override
    public SynthesizedSelector getAnnotationSelector() {
        return this.annotationSelector;
    }

    @Override
    public SynthesizedProcessor getAttributeProcessor() {
        return this.attributeProcessor;
    }

    @Override
    public Synthesized getSynthesizedAnnotation(Class<?> annotationType) {
        return this.metaAnnotationMap.get(annotationType);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.getClass();
    }

    @Override
    public Object getAttribute(String attributeName, Class<?> attributeType) {
        return this.attributeProcessor.getAttributeValue(attributeName, attributeType, this.metaAnnotationMap.values());
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)((Annotation)Optional.ofNullable(annotationType).map(this.metaAnnotationMap::get).map(Synthesized::getAnnotation).map(annotationType::cast).orElse(null));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.metaAnnotationMap.containsKey(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getMetaAnnotationMap().values().toArray(new Meta[0]);
    }

    @Override
    public <T extends Annotation> T syntheticAnnotation(Class<T> annotationType) {
        return SyntheticProxy.create(annotationType, this);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[]{this.getSource()};
    }

    private void loadMetaAnnotations() {
        Assert.isFalse(SyntheticProxy.isProxyAnnotation(this.source.getClass()), "source [{}] has been synthesized", new Object[0]);
        this.metaAnnotationMap.put(this.source.annotationType(), new Meta(this.source, this.source, 0, 0));
        new MetaScanner().scan((index, annotation) -> {
            Synthesized oldAnnotation = this.metaAnnotationMap.get(annotation.annotationType());
            Meta newAnnotation = new Meta(this.source, (Annotation)annotation, (int)index, this.metaAnnotationMap.size());
            if (ObjectKit.isNull(oldAnnotation)) {
                this.metaAnnotationMap.put(annotation.annotationType(), newAnnotation);
            } else {
                this.metaAnnotationMap.put(annotation.annotationType(), this.annotationSelector.choose(oldAnnotation, newAnnotation));
            }
        }, this.source.annotationType(), null);
    }

    public static class Meta
    implements Annotation,
    Synthesized {
        private final Annotation root;
        private final Annotation annotation;
        private final Map<String, Method> attributeMethodCaches;
        private final int verticalDistance;
        private final int horizontalDistance;

        public Meta(Annotation root, Annotation annotation, int verticalDistance, int horizontalDistance) {
            this.root = root;
            this.annotation = annotation;
            this.verticalDistance = verticalDistance;
            this.horizontalDistance = horizontalDistance;
            this.attributeMethodCaches = AnnoKit.getAttributeMethods(annotation.annotationType());
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.annotation.annotationType();
        }

        @Override
        public Annotation getRoot() {
            return this.root;
        }

        @Override
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public int getVerticalDistance() {
            return this.verticalDistance;
        }

        @Override
        public int getHorizontalDistance() {
            return this.horizontalDistance;
        }

        public boolean hasAttribute(String attributeName) {
            return this.attributeMethodCaches.containsKey(attributeName);
        }

        @Override
        public boolean hasAttribute(String attributeName, Class<?> returnType) {
            return Optional.ofNullable(this.attributeMethodCaches.get(attributeName)).filter(method -> ClassKit.isAssignable(returnType, method.getReturnType())).isPresent();
        }

        @Override
        public Object getAttribute(String attributeName) {
            return Optional.ofNullable(this.attributeMethodCaches.get(attributeName)).map(method -> ReflectKit.invoke((Object)this.annotation, method, new Object[0])).orElse(null);
        }
    }
}

