/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aoju.bus.core.scanner.Synthesized;
import org.aoju.bus.core.scanner.Synthetic;
import org.aoju.bus.core.toolkit.AnnoKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

class SyntheticProxy
implements InvocationHandler {
    private final Synthetic synthetic;
    private final Synthesized annotation;
    private final Map<String, BiFunction<Method, Object[], Object>> methods;

    SyntheticProxy(Synthetic synthetic, Synthesized annotation) {
        this.synthetic = synthetic;
        this.annotation = annotation;
        this.methods = new HashMap<String, BiFunction<Method, Object[], Object>>(9);
        this.loadMethods();
    }

    static <T extends Annotation> T create(Class<T> annotationType, Synthetic synthetic) {
        Synthesized annotation = synthetic.getSynthesizedAnnotation(annotationType);
        SyntheticProxy proxyHandler = new SyntheticProxy(synthetic, annotation);
        if (ObjectKit.isNull(annotation)) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType, Proxys.class}, (InvocationHandler)proxyHandler));
    }

    static boolean isProxyAnnotation(Class<?> targetClass) {
        return ClassKit.isAssignable(Proxys.class, targetClass);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return Optional.ofNullable(this.methods.get(method.getName())).map(m -> m.apply(method, args)).orElseGet(() -> ReflectKit.invoke((Object)this, method, args));
    }

    void loadMethods() {
        this.methods.put("toString", (method, args) -> this.proxyToString());
        this.methods.put("hashCode", (method, args) -> this.proxyHashCode());
        this.methods.put("getSyntheticAnnotation", (method, args) -> this.proxyGetSyntheticAnnotation());
        this.methods.put("getSynthesizedAnnotation", (method, args) -> this.proxyGetSynthesizedAnnotation());
        this.methods.put("getRoot", (method, args) -> this.annotation.getRoot());
        this.methods.put("isRoot", (method, args) -> this.annotation.isRoot());
        this.methods.put("getVerticalDistance", (method, args) -> this.annotation.getVerticalDistance());
        this.methods.put("getHorizontalDistance", (method, args) -> this.annotation.getHorizontalDistance());
        this.methods.put("hasAttribute", (method, args) -> this.annotation.hasAttribute((String)args[0], (Class)args[1]));
        this.methods.put("getAttribute", (method, args) -> this.annotation.getAttribute((String)args[0]));
        this.methods.put("annotationType", (method, args) -> this.annotation.annotationType());
        for (Method declaredMethod : this.annotation.getAnnotation().annotationType().getDeclaredMethods()) {
            this.methods.put(declaredMethod.getName(), (method, args) -> this.proxyAttributeValue((Method)method));
        }
    }

    private String proxyToString() {
        String attributes = Stream.of(this.annotation.annotationType().getDeclaredMethods()).filter(AnnoKit::isAttributeMethod).map(method -> StringKit.format((CharSequence)"{}={}", method.getName(), this.synthetic.getAttribute(method.getName(), method.getReturnType()))).collect(Collectors.joining(", "));
        return StringKit.format((CharSequence)"@{}({})", this.annotation.annotationType().getName(), attributes);
    }

    private int proxyHashCode() {
        return Objects.hash(this.synthetic, this.annotation);
    }

    private Object proxyGetSyntheticAnnotation() {
        return this.synthetic;
    }

    private Object proxyGetSynthesizedAnnotation() {
        return this.annotation;
    }

    private Object proxyAttributeValue(Method attributeMethod) {
        return this.synthetic.getAttribute(attributeMethod.getName(), attributeMethod.getReturnType());
    }

    static interface Proxys
    extends Synthesized {
        public Synthetic getSyntheticAnnotation();

        public Synthesized getSynthesizedAnnotation();
    }
}

