/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class PhoneKit {
    public static boolean isMobile(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE, value);
    }

    public static boolean isMobileHk(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE_HK, value);
    }

    public static boolean isMobileTw(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE_TW, value);
    }

    public static boolean isMobileMo(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE_MO, value);
    }

    public static boolean isPhone(CharSequence value) {
        return Validator.isMatchRegex(RegEx.PHONE, value);
    }

    public static boolean isPhone400800(CharSequence value) {
        return Validator.isMatchRegex(RegEx.PHONE_400_800, value);
    }

    public static boolean isPhoneAll(CharSequence value) {
        return PhoneKit.isMobile(value) || PhoneKit.isPhone400800(value) || PhoneKit.isMobileHk(value) || PhoneKit.isMobileTw(value) || PhoneKit.isMobileMo(value);
    }

    public static CharSequence hideBefore(CharSequence phone) {
        return StringKit.hide(phone, 0, 7);
    }

    public static CharSequence hideBetween(CharSequence phone) {
        return StringKit.hide(phone, 3, 7);
    }

    public static CharSequence hideAfter(CharSequence phone) {
        return StringKit.hide(phone, 7, 11);
    }

    public static CharSequence subBefore(CharSequence phone) {
        return StringKit.sub(phone, 0, 3);
    }

    public static CharSequence subBetween(CharSequence phone) {
        return StringKit.sub(phone, 3, 7);
    }

    public static CharSequence subAfter(CharSequence phone) {
        return StringKit.sub(phone, 7, 11);
    }

    public static CharSequence subPhoneBefore(CharSequence value) {
        return PatternKit.getGroup1(RegEx.PHONE, value);
    }

    public static CharSequence subPhoneAfter(CharSequence value) {
        return PatternKit.get(RegEx.PHONE, value, 2);
    }
}

