/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.ByRef;
import org.aoju.bus.health.unix.OpenBsdLibc;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class OpenBsdSysctlKit {
    private static final String SYSCTL_N = "sysctl -n ";
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    public static int sysctl(int[] name, int def) {
        int intSize = OpenBsdLibc.INT_SIZE;
        try (Memory p = new Memory((long)intSize);){
            ByRef.CloseableSizeTByReference size;
            block12: {
                size = new ByRef.CloseableSizeTByReference(intSize);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) break block12;
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    int n = def;
                    size.close();
                    return n;
                }
                catch (Throwable throwable) {
                    try {
                        size.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n = p.getInt(0L);
            size.close();
            return n;
        }
    }

    public static long sysctl(int[] name, long def) {
        int uint64Size = OpenBsdLibc.UINT64_SIZE;
        try (Memory p = new Memory((long)uint64Size);){
            ByRef.CloseableSizeTByReference size;
            block12: {
                size = new ByRef.CloseableSizeTByReference(uint64Size);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) break block12;
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    long l = def;
                    size.close();
                    return l;
                }
                catch (Throwable throwable) {
                    try {
                        size.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l = p.getLong(0L);
            size.close();
            return l;
        }
    }

    public static String sysctl(int[] name, String def) {
        try (ByRef.CloseableSizeTByReference size = new ByRef.CloseableSizeTByReference();){
            Memory p;
            block14: {
                String string;
                if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, LibCAPI.size_t.ZERO)) {
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    String string2 = def;
                    return string2;
                }
                p = new Memory(size.longValue() + 1L);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, size, null, LibCAPI.size_t.ZERO)) break block14;
                    Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
                    string = def;
                }
                catch (Throwable throwable) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                p.close();
                return string;
            }
            String string = p.getString(0L);
            p.close();
            return string;
        }
    }

    public static boolean sysctl(int[] name, Structure struct) {
        try (ByRef.CloseableSizeTByReference size = new ByRef.CloseableSizeTByReference(struct.size());){
            if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, struct.getPointer(), size, null, LibCAPI.size_t.ZERO)) {
                Logger.error(SYSCTL_FAIL, name, Native.getLastError());
                boolean bl = false;
                return bl;
            }
        }
        struct.read();
        return true;
    }

    public static Memory sysctl(int[] name) {
        try (ByRef.CloseableSizeTByReference size = new ByRef.CloseableSizeTByReference();){
            if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, LibCAPI.size_t.ZERO)) {
                Logger.error(SYSCTL_FAIL, name, Native.getLastError());
                Memory memory = null;
                return memory;
            }
            Memory m = new Memory(size.longValue());
            if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)m, size, null, LibCAPI.size_t.ZERO)) {
                Logger.error(SYSCTL_FAIL, name, Native.getLastError());
                m.close();
                Memory memory = null;
                return memory;
            }
            Memory memory = m;
            return memory;
        }
    }

    public static int sysctl(String name, int def) {
        return Builder.parseIntOrDefault(Executor.getFirstAnswer(SYSCTL_N + name), def);
    }

    public static long sysctl(String name, long def) {
        return Builder.parseLongOrDefault(Executor.getFirstAnswer(SYSCTL_N + name), def);
    }

    public static String sysctl(String name, String def) {
        String v = Executor.getFirstAnswer(SYSCTL_N + name);
        if (null == v || v.isEmpty()) {
            return def;
        }
        return v;
    }
}

