/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;

@Immutable
public class OpenBsdFirmware
extends AbstractFirmware {
    private final Supplier<Triple<String, String, String>> manufVersRelease = Memoize.memoize(OpenBsdFirmware::readDmesg);

    private static Triple<String, String, String> readDmesg() {
        String version = null;
        String vendor = null;
        String releaseDate = "";
        List<String> dmesg = Executor.runNative("dmesg");
        for (String line : dmesg) {
            if (!line.startsWith("bios0: vendor")) continue;
            version = Builder.getStringBetween(line, '\"');
            releaseDate = Builder.parseMmDdYyyyToYyyyMmDD(Builder.parseLastString(line));
            vendor = line.split("vendor")[1].trim();
        }
        return Triple.of(StringKit.isBlank(vendor) ? "unknown" : vendor, StringKit.isBlank(version) ? "unknown" : version, StringKit.isBlank(releaseDate) ? "unknown" : releaseDate);
    }

    @Override
    public String getManufacturer() {
        return this.manufVersRelease.get().getLeft();
    }

    @Override
    public String getVersion() {
        return this.manufVersRelease.get().getMiddle();
    }

    @Override
    public String getReleaseDate() {
        return this.manufVersRelease.get().getRight();
    }
}

