/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows;

import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.annotation.NotThreadSafe;
import org.aoju.bus.health.Formats;
import org.aoju.bus.health.builtin.ByRef;
import org.aoju.bus.health.windows.PerfDataKit;
import org.aoju.bus.logger.Logger;

@NotThreadSafe
public final class PerfCounterQueryHandler
implements AutoCloseable {
    private Map<PerfDataKit.PerfCounter, ByRef.CloseableHANDLEByReference> counterHandleMap = new HashMap<PerfDataKit.PerfCounter, ByRef.CloseableHANDLEByReference>();
    private ByRef.CloseableHANDLEByReference queryHandle = null;

    public boolean addCounterToQuery(PerfDataKit.PerfCounter counter) {
        if (this.queryHandle == null) {
            this.queryHandle = new ByRef.CloseableHANDLEByReference();
            if (!PerfDataKit.openQuery(this.queryHandle)) {
                Logger.warn("Failed to open a query for PDH counter: {}", counter.getCounterPath());
                this.queryHandle.close();
                this.queryHandle = null;
                return false;
            }
        }
        ByRef.CloseableHANDLEByReference p = new ByRef.CloseableHANDLEByReference();
        if (!PerfDataKit.addCounter(this.queryHandle, counter.getCounterPath(), p)) {
            Logger.warn("Failed to add counter for PDH counter: {}", counter.getCounterPath());
            p.close();
            return false;
        }
        this.counterHandleMap.put(counter, p);
        return true;
    }

    public boolean removeCounterFromQuery(PerfDataKit.PerfCounter counter) {
        boolean success = false;
        try (ByRef.CloseableHANDLEByReference href = this.counterHandleMap.remove(counter);){
            if (href != null) {
                success = PerfDataKit.removeCounter(href);
            }
        }
        if (this.counterHandleMap.isEmpty()) {
            PerfDataKit.closeQuery(this.queryHandle);
            this.queryHandle.close();
            this.queryHandle = null;
        }
        return success;
    }

    public void removeAllCounters() {
        for (ByRef.CloseableHANDLEByReference href : this.counterHandleMap.values()) {
            PerfDataKit.removeCounter(href);
            href.close();
        }
        this.counterHandleMap.clear();
        if (this.queryHandle != null) {
            PerfDataKit.closeQuery(this.queryHandle);
            this.queryHandle.close();
            this.queryHandle = null;
        }
    }

    public long updateQuery() {
        if (this.queryHandle == null) {
            Logger.warn("Query does not exist to update.", new Object[0]);
            return 0L;
        }
        return PerfDataKit.updateQueryTimestamp(this.queryHandle);
    }

    public long queryCounter(PerfDataKit.PerfCounter counter) {
        long value;
        if (!this.counterHandleMap.containsKey(counter)) {
            if (Logger.isWarn()) {
                Logger.warn("Counter {} does not exist to query.", counter.getCounterPath());
            }
            return 0L;
        }
        long l = value = counter.isBaseCounter() ? PerfDataKit.querySecondCounter(this.counterHandleMap.get(counter)) : PerfDataKit.queryCounter(this.counterHandleMap.get(counter));
        if (value < 0L) {
            if (Logger.isWarn()) {
                Logger.warn("Error querying counter {}: {}", counter.getCounterPath(), String.format(Formats.formatError((int)value), new Object[0]));
            }
            return 0L;
        }
        return value;
    }

    @Override
    public void close() {
        this.removeAllCounters();
    }
}

