/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.VersionHelpers;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractGraphicsCard;
import org.aoju.bus.health.builtin.hardware.GraphicsCard;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.wmi.Win32VideoController;

@Immutable
final class WindowsGraphicsCard
extends AbstractGraphicsCard {
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    WindowsGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super(name, deviceId, vendor, versionInfo, vram);
    }

    public static List<GraphicsCard> getGraphicsCards() {
        ArrayList<GraphicsCard> cardList = new ArrayList<GraphicsCard>();
        if (IS_VISTA_OR_GREATER) {
            WbemcliUtil.WmiResult<Win32VideoController.VideoControllerProperty> cards = Win32VideoController.queryVideoController();
            for (int index = 0; index < cards.getResultCount(); ++index) {
                Object versionInfo;
                String name = WmiKit.getString(cards, Win32VideoController.VideoControllerProperty.NAME, index);
                Triple<String, String, String> idPair = Builder.parseDeviceIdToVendorProductSerial(WmiKit.getString(cards, Win32VideoController.VideoControllerProperty.PNPDEVICEID, index));
                String deviceId = idPair == null ? "unknown" : idPair.getMiddle();
                Object vendor = WmiKit.getString(cards, Win32VideoController.VideoControllerProperty.ADAPTERCOMPATIBILITY, index);
                if (idPair != null) {
                    if (StringKit.isBlank((CharSequence)vendor)) {
                        deviceId = idPair.getLeft();
                    } else {
                        vendor = (String)vendor + " (" + idPair.getLeft() + ")";
                    }
                }
                versionInfo = !StringKit.isBlank((CharSequence)(versionInfo = WmiKit.getString(cards, Win32VideoController.VideoControllerProperty.DRIVERVERSION, index))) ? "DriverVersion=" + (String)versionInfo : "unknown";
                long vram = WmiKit.getUint32asLong(cards, Win32VideoController.VideoControllerProperty.ADAPTERRAM, index);
                cardList.add(new WindowsGraphicsCard(StringKit.isBlank(name) ? "unknown" : name, deviceId, (String)(StringKit.isBlank((CharSequence)vendor) ? "unknown" : vendor), (String)versionInfo, vram));
            }
        }
        return cardList;
    }
}

