/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.accord;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import org.aoju.bus.core.io.buffer.Buffer;
import org.aoju.bus.core.io.sink.AssignSink;
import org.aoju.bus.core.io.sink.Sink;
import org.aoju.bus.core.io.source.AssignSource;
import org.aoju.bus.core.io.source.Source;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.ExchangeFinder;
import org.aoju.bus.http.accord.RealConnection;
import org.aoju.bus.http.accord.Transmitter;
import org.aoju.bus.http.bodys.RealResponseBody;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.metric.EventListener;
import org.aoju.bus.http.metric.Internal;
import org.aoju.bus.http.metric.http.HttpCodec;
import org.aoju.bus.http.socket.RealWebSocket;

public class Exchange {
    final Transmitter transmitter;
    final NewCall call;
    final EventListener eventListener;
    final ExchangeFinder finder;
    final HttpCodec httpCodec;
    private boolean duplex;

    public Exchange(Transmitter transmitter, NewCall call, EventListener eventListener, ExchangeFinder finder, HttpCodec httpCodec) {
        this.transmitter = transmitter;
        this.call = call;
        this.eventListener = eventListener;
        this.finder = finder;
        this.httpCodec = httpCodec;
    }

    public RealConnection connection() {
        return this.httpCodec.connection();
    }

    public boolean isDuplex() {
        return this.duplex;
    }

    public void writeRequestHeaders(Request request) throws IOException {
        try {
            this.eventListener.requestHeadersStart(this.call);
            this.httpCodec.writeRequestHeaders(request);
            this.eventListener.requestHeadersEnd(this.call, request);
        }
        catch (IOException e) {
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public Sink createRequestBody(Request request, boolean duplex) throws IOException {
        this.duplex = duplex;
        long length = request.body().length();
        this.eventListener.requestBodyStart(this.call);
        Sink rawRequestBody = this.httpCodec.createRequestBody(request, length);
        return new RequestBodySink(rawRequestBody, length);
    }

    public void flushRequest() throws IOException {
        try {
            this.httpCodec.flushRequest();
        }
        catch (IOException e) {
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public void finishRequest() throws IOException {
        try {
            this.httpCodec.finishRequest();
        }
        catch (IOException e) {
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public void responseHeadersStart() {
        this.eventListener.responseHeadersStart(this.call);
    }

    public Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        try {
            Response.Builder result = this.httpCodec.readResponseHeaders(expectContinue);
            if (result != null) {
                Internal.instance.initExchange(result, this);
            }
            return result;
        }
        catch (IOException e) {
            this.eventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public void responseHeadersEnd(Response response) {
        this.eventListener.responseHeadersEnd(this.call, response);
    }

    public ResponseBody openResponseBody(Response response) throws IOException {
        try {
            this.eventListener.responseBodyStart(this.call);
            String mediaType = response.header("Content-Type");
            long length = this.httpCodec.reportedContentLength(response);
            Source rawSource = this.httpCodec.openResponseBodySource(response);
            ResponseBodySource source = new ResponseBodySource(rawSource, length);
            return new RealResponseBody(mediaType, length, IoKit.buffer(source));
        }
        catch (IOException e) {
            this.eventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public Headers trailers() throws IOException {
        return this.httpCodec.trailers();
    }

    public void timeoutEarlyExit() {
        this.transmitter.timeoutEarlyExit();
    }

    public RealWebSocket.Streams newWebSocketStreams() throws SocketException {
        this.transmitter.timeoutEarlyExit();
        return this.httpCodec.connection().newWebSocketStreams(this);
    }

    public void webSocketUpgradeFailed() {
        this.bodyComplete(-1L, true, true, null);
    }

    public void noNewExchangesOnConnection() {
        this.httpCodec.connection().noNewExchanges();
    }

    public void cancel() {
        this.httpCodec.cancel();
    }

    public void detachWithViolence() {
        this.httpCodec.cancel();
        this.transmitter.exchangeMessageDone(this, true, true, null);
    }

    void trackFailure(IOException e) {
        this.finder.trackFailure();
        this.httpCodec.connection().trackFailure(e);
    }

    IOException bodyComplete(long bytesRead, boolean responseDone, boolean requestDone, IOException e) {
        if (e != null) {
            this.trackFailure(e);
        }
        if (requestDone) {
            if (e != null) {
                this.eventListener.requestFailed(this.call, e);
            } else {
                this.eventListener.requestBodyEnd(this.call, bytesRead);
            }
        }
        if (responseDone) {
            if (e != null) {
                this.eventListener.responseFailed(this.call, e);
            } else {
                this.eventListener.responseBodyEnd(this.call, bytesRead);
            }
        }
        return this.transmitter.exchangeMessageDone(this, requestDone, responseDone, e);
    }

    public void noRequestBody() {
        this.transmitter.exchangeMessageDone(this, true, false, null);
    }

    private class RequestBodySink
    extends AssignSink {
        private boolean completed;
        private long contentLength;
        private long bytesReceived;
        private boolean closed;

        RequestBodySink(Sink delegate, long contentLength) {
            super(delegate);
            this.contentLength = contentLength;
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.contentLength != -1L && this.bytesReceived + byteCount > this.contentLength) {
                throw new ProtocolException("expected " + this.contentLength + " bytes but received " + (this.bytesReceived + byteCount));
            }
            try {
                super.write(source, byteCount);
                this.bytesReceived += byteCount;
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.contentLength != -1L && this.bytesReceived != this.contentLength) {
                throw new ProtocolException("unexpected end of stream");
            }
            try {
                super.close();
                this.complete(null);
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        private IOException complete(IOException e) {
            if (this.completed) {
                return e;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, false, true, e);
        }
    }

    class ResponseBodySource
    extends AssignSource {
        private final long contentLength;
        private long bytesReceived;
        private boolean completed;
        private boolean closed;

        ResponseBodySource(Source delegate, long contentLength) {
            super(delegate);
            this.contentLength = contentLength;
            if (contentLength == 0L) {
                this.complete(null);
            }
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            try {
                long read = this.delegate().read(sink, byteCount);
                if (read == -1L) {
                    this.complete(null);
                    return -1L;
                }
                long newBytesReceived = this.bytesReceived + read;
                if (this.contentLength != -1L && newBytesReceived > this.contentLength) {
                    throw new ProtocolException("expected " + this.contentLength + " bytes but received " + newBytesReceived);
                }
                this.bytesReceived = newBytesReceived;
                if (newBytesReceived == this.contentLength) {
                    this.complete(null);
                }
                return read;
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                this.complete(null);
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        IOException complete(IOException e) {
            if (this.completed) {
                return e;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, true, false, e);
        }
    }
}

