/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.sink.BufferSink;
import org.aoju.bus.core.io.source.Source;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Builder;

public abstract class RequestBody {
    public static RequestBody create(MediaType mediaType, String content) {
        java.nio.charset.Charset charset = Charset.UTF_8;
        if (null != mediaType) {
            charset = null != mediaType.charset() ? mediaType.charset() : Charset.UTF_8;
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(mediaType, bytes);
    }

    public static RequestBody create(final MediaType mediaType, final ByteString content) {
        return new RequestBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return content.size();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, byte[] content) {
        return RequestBody.create(mediaType, content, 0, content.length);
    }

    public static RequestBody create(final MediaType mediaType, final byte[] content, final int offset, final int byteCount) {
        if (null == content) {
            throw new NullPointerException("content == null");
        }
        Builder.checkOffsetAndCount(content.length, offset, byteCount);
        return new RequestBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return byteCount;
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content, offset, byteCount);
            }
        };
    }

    public static RequestBody create(final MediaType mediaType, final File file) {
        if (null == file) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return file.length();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                try (Source source = IoKit.source(file);){
                    sink.writeAll(source);
                }
            }
        };
    }

    public abstract MediaType mediaType();

    public long length() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferSink var1) throws IOException;

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }
}

