/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.cache.CacheControl;
import org.aoju.bus.http.metric.Internal;

public class CacheStrategy {
    public final Request networkRequest;
    public final Response cacheResponse;

    CacheStrategy(Request networkRequest, Response cacheResponse) {
        this.networkRequest = networkRequest;
        this.cacheResponse = cacheResponse;
    }

    public static boolean isCacheable(Response response, Request request) {
        switch (response.code()) {
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                break;
            }
            case 302: 
            case 307: {
                if (null != response.header("Expires") || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
            }
            default: {
                return false;
            }
        }
        return !response.cacheControl().noStore() && !request.cacheControl().noStore();
    }

    public static class Factory {
        final long nowMillis;
        final Request request;
        final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds = -1;

        public Factory(long nowMillis, Request request, Response cacheResponse) {
            this.nowMillis = nowMillis;
            this.request = request;
            this.cacheResponse = cacheResponse;
            if (null != cacheResponse) {
                this.sentRequestMillis = cacheResponse.sentRequestAtMillis();
                this.receivedResponseMillis = cacheResponse.receivedResponseAtMillis();
                Headers headers = cacheResponse.headers();
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    String fieldName = headers.name(i);
                    String value = headers.value(i);
                    if ("Date".equalsIgnoreCase(fieldName)) {
                        this.servedDate = Builder.parse(value);
                        this.servedDateString = value;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(fieldName)) {
                        this.expires = Builder.parse(value);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase(fieldName)) {
                        this.lastModified = Builder.parse(value);
                        this.lastModifiedString = value;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase(fieldName)) {
                        this.etag = value;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase(fieldName)) continue;
                    this.ageSeconds = Headers.parseSeconds(value, -1);
                }
            }
        }

        private static boolean hasConditions(Request request) {
            return null != request.header("If-Modified-Since") || null != request.header("If-None-Match");
        }

        public CacheStrategy get() {
            CacheStrategy candidate = this.getCandidate();
            if (null != candidate.networkRequest && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return candidate;
        }

        private CacheStrategy getCandidate() {
            String conditionValue;
            String conditionName;
            if (null == this.cacheResponse) {
                return new CacheStrategy(this.request, null);
            }
            if (this.request.isHttps() && null == this.cacheResponse.handshake()) {
                return new CacheStrategy(this.request, null);
            }
            if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                return new CacheStrategy(this.request, null);
            }
            CacheControl requestCaching = this.request.cacheControl();
            if (requestCaching.noCache() || Factory.hasConditions(this.request)) {
                return new CacheStrategy(this.request, null);
            }
            CacheControl responseCaching = this.cacheResponse.cacheControl();
            long ageMillis = this.cacheResponseAge();
            long freshMillis = this.computeFreshnessLifetime();
            if (requestCaching.maxAgeSeconds() != -1) {
                freshMillis = Math.min(freshMillis, TimeUnit.SECONDS.toMillis(requestCaching.maxAgeSeconds()));
            }
            long minFreshMillis = 0L;
            if (requestCaching.minFreshSeconds() != -1) {
                minFreshMillis = TimeUnit.SECONDS.toMillis(requestCaching.minFreshSeconds());
            }
            long maxStaleMillis = 0L;
            if (!responseCaching.mustRevalidate() && requestCaching.maxStaleSeconds() != -1) {
                maxStaleMillis = TimeUnit.SECONDS.toMillis(requestCaching.maxStaleSeconds());
            }
            if (!responseCaching.noCache() && ageMillis + minFreshMillis < freshMillis + maxStaleMillis) {
                long oneDayMillis;
                Response.Builder builder = this.cacheResponse.newBuilder();
                if (ageMillis + minFreshMillis >= freshMillis) {
                    builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                }
                if (ageMillis > (oneDayMillis = 86400000L) && this.isFreshnessLifetimeHeuristic()) {
                    builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                }
                return new CacheStrategy(null, builder.build());
            }
            if (null != this.etag) {
                conditionName = "If-None-Match";
                conditionValue = this.etag;
            } else if (null != this.lastModified) {
                conditionName = "If-Modified-Since";
                conditionValue = this.lastModifiedString;
            } else if (null != this.servedDate) {
                conditionName = "If-Modified-Since";
                conditionValue = this.servedDateString;
            } else {
                return new CacheStrategy(this.request, null);
            }
            Headers.Builder conditionalRequestHeaders = this.request.headers().newBuilder();
            Internal.instance.addLenient(conditionalRequestHeaders, conditionName, conditionValue);
            Request conditionalRequest = this.request.newBuilder().headers(conditionalRequestHeaders.build()).build();
            return new CacheStrategy(conditionalRequest, this.cacheResponse);
        }

        private long computeFreshnessLifetime() {
            CacheControl responseCaching = this.cacheResponse.cacheControl();
            if (responseCaching.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(responseCaching.maxAgeSeconds());
            }
            if (null != this.expires) {
                long servedMillis = null != this.servedDate ? this.servedDate.getTime() : this.receivedResponseMillis;
                long delta = this.expires.getTime() - servedMillis;
                return delta > 0L ? delta : 0L;
            }
            if (null != this.lastModified && null == this.cacheResponse.request().url().query()) {
                long servedMillis = null != this.servedDate ? this.servedDate.getTime() : this.sentRequestMillis;
                long delta = servedMillis - this.lastModified.getTime();
                return delta > 0L ? delta / 10L : 0L;
            }
            return 0L;
        }

        private long cacheResponseAge() {
            long apparentReceivedAge = null != this.servedDate ? Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime()) : 0L;
            long receivedAge = this.ageSeconds != -1 ? Math.max(apparentReceivedAge, TimeUnit.SECONDS.toMillis(this.ageSeconds)) : apparentReceivedAge;
            long responseDuration = this.receivedResponseMillis - this.sentRequestMillis;
            long residentDuration = this.nowMillis - this.receivedResponseMillis;
            return receivedAge + responseDuration + residentDuration;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && null == this.expires;
        }
    }
}

