/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpv;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.aoju.bus.core.io.buffer.Buffer;
import org.aoju.bus.core.io.sink.AssignSink;
import org.aoju.bus.core.io.sink.BufferSink;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.plugin.httpv.Progress;

public class ProgressBody
extends RequestBody {
    private RequestBody requestBody;
    private Callback<Progress> onProcess;
    private Executor callbackExecutor;
    private long stepBytes;
    private long step = 0L;
    private Progress progress;
    private boolean doneCalled = false;
    private BufferSink bufferedSink;

    public ProgressBody(RequestBody requestBody, Callback<Progress> onProcess, Executor callbackExecutor, long contentLength, long stepBytes) {
        this.requestBody = requestBody;
        this.onProcess = onProcess;
        this.callbackExecutor = callbackExecutor;
        this.stepBytes = stepBytes;
        this.progress = new Progress(contentLength, 0L);
    }

    @Override
    public long length() {
        return this.progress.getTotalBytes();
    }

    @Override
    public MediaType mediaType() {
        return this.requestBody.mediaType();
    }

    @Override
    public void writeTo(BufferSink sink) throws IOException {
        if (null == this.bufferedSink) {
            this.bufferedSink = IoKit.buffer(new AssignSink(sink){

                @Override
                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    ProgressBody.this.progress.addDoneBytes(byteCount);
                    if (ProgressBody.this.progress.notDoneOrReached(ProgressBody.this.step * ProgressBody.this.stepBytes)) {
                        return;
                    }
                    if (ProgressBody.this.progress.isDone()) {
                        if (ProgressBody.this.doneCalled) {
                            return;
                        }
                        ProgressBody.this.doneCalled = true;
                    }
                    ++ProgressBody.this.step;
                    ProgressBody.this.callbackExecutor.execute(() -> ProgressBody.this.onProcess.on(ProgressBody.this.progress));
                }
            });
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }
}

