/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpv;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.plugin.httpv.Progress;

public class ProgressStream
extends InputStream {
    private InputStream input;
    private Callback<Progress> onProcess;
    private Executor callbackExecutor;
    private long stepBytes;
    private long step;
    private Progress progress;
    private boolean doneCalled = false;

    public ProgressStream(InputStream input, Callback<Progress> onProcess, long totalBytes, long stepBytes, long doneBytes, Executor callbackExecutor) {
        this.input = input;
        this.onProcess = onProcess;
        this.stepBytes = stepBytes;
        this.callbackExecutor = callbackExecutor;
        this.progress = new Progress(totalBytes, doneBytes);
        this.step = doneBytes / stepBytes;
    }

    @Override
    public int read() throws IOException {
        int data = this.input.read();
        if (data > -1) {
            this.progress.increaseDoneBytes();
        }
        if (this.progress.notDoneOrReached(this.step * this.stepBytes)) {
            return data;
        }
        if (this.progress.isDone()) {
            if (this.doneCalled) {
                return data;
            }
            this.doneCalled = true;
        }
        ++this.step;
        this.callbackExecutor.execute(() -> this.onProcess.on(this.progress));
        return data;
    }
}

