/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpz;

import java.io.IOException;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.plugin.httpz.HttpRequest;
import org.aoju.bus.http.plugin.httpz.HttpzState;

public class RequestCall {
    private Httpd httpd;
    private HttpRequest httpRequest;
    private Request request;
    private NewCall newCall;

    public RequestCall(HttpRequest request, Httpd httpd) {
        this.httpRequest = request;
        this.httpd = httpd;
    }

    public NewCall buildCall(Callback callback) {
        this.request = this.createRequest(callback);
        this.newCall = this.httpd.newCall(this.request);
        return this.newCall;
    }

    private Request createRequest(Callback callback) {
        return this.httpRequest.createRequest(callback);
    }

    public Response execute() throws Exception {
        this.buildCall(null);
        try {
            Response response = this.newCall.execute();
            if (response.isSuccessful()) {
                HttpzState.onReqSuccess();
            } else {
                HttpzState.onReqFailure(this.newCall.request().url().toString(), null);
            }
            return response;
        }
        catch (Exception e) {
            HttpzState.onReqFailure(this.newCall.request().url().toString(), e);
            throw e;
        }
    }

    public void executeAsync(Callback callback) {
        this.buildCall(callback);
        this.execute(this, callback);
    }

    private void execute(RequestCall requestCall, final Callback callback) {
        final String id = requestCall.getHttpRequest().getId();
        requestCall.getNewCall().enqueue(new Callback(){

            @Override
            public void onFailure(NewCall newCall, IOException e) {
                HttpzState.onReqFailure(newCall.request().url().toString(), e);
                if (null != callback) {
                    callback.onFailure(newCall, e, id);
                }
            }

            @Override
            public void onResponse(NewCall newCall, Response response) {
                HttpzState.onReqSuccess();
                if (null != callback) {
                    callback.onResponse(newCall, response, id);
                }
            }
        });
    }

    public NewCall getNewCall() {
        return this.newCall;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void cancel() {
        if (null != this.newCall) {
            this.newCall.cancel();
        }
    }
}

