/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.builtin.Multiframe;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;

public class Emf2sf {
    private final Multiframe extractor = new Multiframe();
    private int[] frames;
    private DecimalFormat outFileFormat;
    private File outDir;

    private static int[] toFrames(String[] ss) throws InstrumentException {
        if (null == ss) {
            return null;
        }
        int[] is = new int[ss.length];
        for (int i = 0; i < is.length; ++i) {
            try {
                is[i] = Integer.parseInt(ss[i]) - 1;
                continue;
            }
            catch (NumberFormatException e) {
                throw new InstrumentException("Invalid argument of option --frame: " + ss[i]);
            }
        }
        return is;
    }

    public final void setOutputDirectory(File outDir) {
        outDir.mkdirs();
        this.outDir = outDir;
    }

    public final void setOutputFileFormat(String outFileFormat) {
        this.outFileFormat = new DecimalFormat(outFileFormat);
    }

    public final void setFrames(int[] frames) {
        this.frames = frames;
    }

    public void setPreserveSeriesInstanceUID(boolean PreserveSeriesInstanceUID) {
        this.extractor.setPreserveSeriesInstanceUID(PreserveSeriesInstanceUID);
    }

    public void setInstanceNumberFormat(String instanceNumberFormat) {
        this.extractor.setInstanceNumberFormat(instanceNumberFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fname(File srcFile, int frame) {
        if (null != this.outFileFormat) {
            DecimalFormat decimalFormat = this.outFileFormat;
            synchronized (decimalFormat) {
                return this.outFileFormat.format(frame);
            }
        }
        return String.format(srcFile.getName() + "-%04d", frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extract(File file) throws IOException {
        Attributes src;
        ImageInputStream dis = new ImageInputStream(file);
        try {
            dis.setIncludeBulkData(ImageInputStream.IncludeBulkData.URI);
            src = dis.readDataset(-1, -1);
        }
        finally {
            IoKit.close(dis);
        }
        Attributes fmi = dis.getFileMetaInformation();
        if (null == this.frames) {
            int n = src.getInt(0x280008, 1);
            for (int frame = 0; frame < n; ++frame) {
                this.extract(file, fmi, src, frame);
            }
            return n;
        }
        for (int frame : this.frames) {
            this.extract(file, fmi, src, frame);
        }
        return this.frames.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(File file, Attributes fmi, Attributes src, int frame) throws IOException {
        Attributes sf = this.extractor.extract(src, frame);
        ImageOutputStream out = new ImageOutputStream(new File(this.outDir, this.fname(file, frame + 1)));
        try {
            out.writeDataset(null != fmi ? sf.createFileMetaInformation(fmi.getString(131088)) : null, sf);
        }
        finally {
            IoKit.close(out);
        }
    }
}

