/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.additional.update.differ;

import java.util.Set;
import org.aoju.bus.core.exception.VersionException;
import org.aoju.bus.mapper.annotation.Version;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SqlBuilder;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.apache.ibatis.mapping.MappedStatement;

public class UpdateByDifferProvider
extends MapperTemplate {
    public static final String OLD = "old";
    public static final String NEWER = "newer";

    public UpdateByDifferProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String updateByDiffer(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass)));
        sql.append(this.updateSetColumnsByDiffer(entityClass));
        sql.append(this.wherePKColumns(entityClass, true));
        return sql.toString();
    }

    public String wherePKColumns(Class<?> entityClass, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnSet = EntityBuilder.getPKColumns(entityClass);
        for (EntityColumn column : columnSet) {
            sql.append(" AND " + column.getColumnEqualsHolder(NEWER));
        }
        if (useVersion) {
            sql.append(this.whereVersion(entityClass));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public String whereVersion(Class<?> entityClass) {
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        boolean hasVersion = false;
        Object result = "";
        for (EntityColumn column : columnSet) {
            if (!column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (hasVersion) {
                throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasVersion = true;
            result = " AND " + column.getColumnEqualsHolder(NEWER);
        }
        return result;
    }

    public String updateSetColumnsByDiffer(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        EntityColumn versionColumn = null;
        for (EntityColumn column : columnSet) {
            if (column.getEntityField().isAnnotationPresent(Version.class)) {
                if (versionColumn != null) {
                    throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                versionColumn = column;
            }
            if (column.isId() || !column.isUpdatable()) continue;
            if (column == versionColumn) {
                Version version = versionColumn.getEntityField().getAnnotation(Version.class);
                String versionClass = version.nextVersion().getCanonicalName();
                sql.append(column.getColumn()).append(" = ${@org.aoju.bus.mapper.version.DefaultNextVersion@nextVersion(").append("@").append(versionClass).append("@class, ").append(column.getProperty()).append(")},");
                continue;
            }
            sql.append(this.getIfNotEqual(column, column.getColumnEqualsHolder(NEWER) + ","));
        }
        sql.append("</set>");
        return sql.toString();
    }

    public String getIfNotEqual(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(OLD).append(".").append(column.getProperty());
        sql.append(" != ").append(NEWER).append(".").append(column.getProperty()).append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }
}

