/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.mapper.builder.resolve.DefaultEntityResolve;
import org.aoju.bus.mapper.builder.resolve.EntityResolve;
import org.aoju.bus.mapper.entity.Config;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityTable;
import org.aoju.bus.mapper.reflect.MetaObject;
import org.apache.ibatis.mapping.MappedStatement;

public class EntityBuilder {
    private static final Map<Class<?>, EntityTable> entityTableMap = new ConcurrentHashMap();
    private static final EntityResolve DEFAULT;
    private static EntityResolve resolve;

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = entityTableMap.get(entityClass);
        if (entityTable == null) {
            throw new InstrumentException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static String getOrderByClause(Class<?> entityClass) {
        EntityTable table = EntityBuilder.getEntityTable(entityClass);
        if (table.getOrderByClause() != null) {
            return table.getOrderByClause();
        }
        ArrayList<EntityColumn> orderEntityColumns = new ArrayList<EntityColumn>();
        for (EntityColumn column : table.getEntityClassColumns()) {
            if (column.getOrderBy() == null) continue;
            orderEntityColumns.add(column);
        }
        Collections.sort(orderEntityColumns, Comparator.comparingInt(EntityColumn::getOrderPriority));
        StringBuilder orderBy = new StringBuilder();
        for (EntityColumn column : orderEntityColumns) {
            if (orderBy.length() != 0) {
                orderBy.append(",");
            }
            orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy());
        }
        table.setOrderByClause(orderBy.toString());
        return table.getOrderByClause();
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return EntityBuilder.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPKColumns(Class<?> entityClass) {
        return EntityBuilder.getEntityTable(entityClass).getEntityClassPKColumns();
    }

    public static String getSelectColumns(Class<?> entityClass) {
        EntityTable entityTable = EntityBuilder.getEntityTable(entityClass);
        if (entityTable.getBaseSelect() != null) {
            return entityTable.getBaseSelect();
        }
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                if (entityColumn.getColumn().substring(1, entityColumn.getColumn().length() - 1).equalsIgnoreCase(entityColumn.getProperty())) {
                    selectBuilder.append(",");
                    continue;
                }
                selectBuilder.append(" AS ").append(entityColumn.getProperty()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        entityTable.setBaseSelect(selectBuilder.substring(0, selectBuilder.length() - 1));
        return entityTable.getBaseSelect();
    }

    public static synchronized void initEntityNameMap(Class<?> entityClass, Config config) {
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        EntityTable entityTable = resolve.resolveEntity(entityClass, config);
        entityTableMap.put(entityClass, entityTable);
    }

    static void setResolve(EntityResolve resolve) {
        EntityBuilder.resolve = resolve;
    }

    public static void setKeyProperties(Set<EntityColumn> pkColumns, MappedStatement ms) {
        if (pkColumns == null || pkColumns.isEmpty()) {
            return;
        }
        ArrayList<String> keyProperties = new ArrayList<String>(pkColumns.size());
        for (EntityColumn column : pkColumns) {
            keyProperties.add(column.getProperty());
        }
        MetaObject.forObject(ms).setValue("keyProperties", (Object)keyProperties.toArray(new String[0]));
    }

    static {
        resolve = DEFAULT = new DefaultEntityResolve();
    }
}

