/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.version;

import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.exception.VersionException;
import org.aoju.bus.mapper.version.NextVersion;

public class DefaultNextVersion
implements NextVersion {
    private static final Map<Class<? extends NextVersion>, NextVersion> CACHE = new ConcurrentHashMap<Class<? extends NextVersion>, NextVersion>();
    private static final ReentrantLock LOCK = new ReentrantLock();

    public static Object nextVersion(Class<? extends NextVersion> nextVersionClass, Object current) throws VersionException {
        try {
            NextVersion nextVersion;
            if (CACHE.containsKey(nextVersionClass)) {
                nextVersion = CACHE.get(nextVersionClass);
            } else {
                LOCK.lock();
                try {
                    if (!CACHE.containsKey(nextVersionClass)) {
                        CACHE.put(nextVersionClass, nextVersionClass.newInstance());
                    }
                    nextVersion = CACHE.get(nextVersionClass);
                }
                finally {
                    LOCK.unlock();
                }
            }
            return nextVersion.nextVersion(current);
        }
        catch (Exception e) {
            throw new VersionException("\u83b7\u53d6\u4e0b\u4e00\u4e2a\u7248\u672c\u53f7\u5931\u8d25!", e);
        }
    }

    public Object nextVersion(Object current) throws VersionException {
        if (current == null) {
            throw new VersionException("\u5f53\u524d\u7248\u672c\u53f7\u4e3a\u7a7a!");
        }
        if (current instanceof Integer) {
            return (Integer)current + 1;
        }
        if (current instanceof Long) {
            return (Long)current + 1L;
        }
        if (current instanceof Timestamp) {
            return new Timestamp(System.currentTimeMillis());
        }
        throw new VersionException("\u9ed8\u8ba4\u7684 NextVersion \u53ea\u652f\u6301 Integer, Long \u548c java.sql.Timestamp \u7c7b\u578b\u7684\u7248\u672c\u53f7\uff0c\u5982\u679c\u6709\u9700\u8981\u8bf7\u81ea\u884c\u6269\u5c55!");
    }
}

