/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.ZoneId;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.magic.Property;
import org.aoju.bus.notify.provider.aliyun.AliyunProperty;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;

public class AliyunEmailProvider
extends AliyunProvider<AliyunProperty, Context> {
    public AliyunEmailProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(AliyunProperty entity) throws InstrumentException {
        if (StringKit.isEmpty(entity.getContent())) {
            throw new InstrumentException("Email content cannot be empty");
        }
        if (StringKit.isEmpty(entity.getReceive())) {
            throw new InstrumentException("Email address cannot be empty");
        }
        if (StringKit.isEmpty(entity.getSubject())) {
            throw new InstrumentException("Email subject cannot be empty");
        }
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("SignatureMethod", "HMAC-SHA1");
        bodys.put("SignatureNonce", UUID.randomUUID().toString());
        bodys.put("AccessKeyId", this.context.getAppKey());
        bodys.put("SignatureVersion", "1.0");
        bodys.put("Timestamp", DateKit.format(new Date(), "yyyy-MM-dd'T'HH:mm:ss'Z'", ZoneId.GMT.name()));
        bodys.put("Format", "JSON");
        bodys.put("Action", "SingleSendMail");
        bodys.put("Version", "2015-11-23");
        bodys.put("RegionId", "cn-hangzhou");
        bodys.put("Subject", entity.getSubject());
        bodys.put("FromAlias", entity.getSender());
        bodys.put("ToAddress", entity.getReceive());
        if (Property.Type.HTML.equals((Object)entity.getType())) {
            bodys.put("HtmlBody", entity.getContent());
        } else if (Property.Type.TEXT.equals((Object)entity.getType())) {
            bodys.put("TextBody", entity.getContent());
        }
        bodys.put("ReplyAddress", entity.getSender());
        bodys.put("ReplyToAddress", entity.getSender());
        bodys.put("ReplyAddressAlias", entity.getSender());
        bodys.put("ClickTrace", this.getSign(bodys));
        bodys.put("Signature", this.getSign(bodys));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String val : bodys.keySet()) {
            map.put(this.specialUrlEncode(val), this.specialUrlEncode((String)bodys.get(val)));
        }
        return this.checkResponse(Httpx.get(entity.getUrl(), map));
    }
}

