/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.netease;

import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.magic.Property;
import org.aoju.bus.notify.provider.AbstractProvider;

public abstract class NeteaseProvider<T extends Property, K extends Context>
extends AbstractProvider<T, K> {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public NeteaseProvider(K properties) {
        super(properties);
    }

    private static String encode(String value) {
        if (null == value) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("sha1");
            messageDigest.update(value.getBytes());
            return NeteaseProvider.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (byte aByte : bytes) {
            buf.append(HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(HEX_DIGITS[aByte & 0xF]);
        }
        return buf.toString();
    }

    protected HashMap<String, String> getPostHeader() {
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AppKey", this.context.getAppKey());
        map.put("Nonce", this.context.getAppNonce());
        map.put("CurTime", curTime);
        map.put("CheckSum", this.getCheckSum(curTime));
        return map;
    }

    public Message post(String routerUrl, Map<String, Object> map) {
        HashMap<String, String> header = this.getPostHeader();
        Logger.debug("netease send\uff1a{}", map);
        String response = Httpx.post(routerUrl, map, header);
        Logger.debug("netease result\uff1a{}", response);
        String code = (String)JsonKit.getValue(response, "Code");
        return Message.builder().errcode(String.valueOf(200).equals(code) ? Builder.ErrorCode.SUCCESS.getCode() : code).errmsg((String)JsonKit.getValue(response, "desc")).build();
    }

    private String getCheckSum(String curTime) {
        return NeteaseProvider.encode(this.context.getAppSecret() + this.context.getAppNonce() + curTime);
    }
}

