/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.builtin;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.office.builtin.ConvertJob;
import org.aoju.bus.office.builtin.OptionalTarget;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.provider.AbstractSourceProvider;
import org.aoju.bus.office.provider.AbstractTargetProvider;

public abstract class AbstractJob
implements OptionalTarget {
    protected AbstractSourceProvider source;
    protected AbstractTargetProvider target;

    protected AbstractJob(AbstractSourceProvider source, AbstractTargetProvider target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public ConvertJob as(DocumentFormat format) {
        this.target.setDocumentFormat(format);
        return this;
    }

    @Override
    public final void execute() throws InstrumentException {
        Assert.notNull(this.target.getFormat(), "The target format is missing or not supported", new Object[0]);
        this.doExecute();
    }

    protected abstract void doExecute() throws InstrumentException;
}

