/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.family;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.magic.family.FamilyType;
import org.aoju.bus.office.magic.family.FormatRegistry;

public class SimpleFormatRegistry
implements FormatRegistry {
    private final Map<String, DocumentFormat> fmtsByExtension = new HashMap<String, DocumentFormat>();
    private final Map<String, DocumentFormat> fmtsByMimeType = new HashMap<String, DocumentFormat>();

    public void addFormat(DocumentFormat documentFormat) {
        documentFormat.getExtensions().stream().map(StringKit::lowerCase).forEach(ext -> this.fmtsByExtension.put((String)ext, documentFormat));
        this.fmtsByMimeType.put(StringKit.lowerCase(documentFormat.getMimeType()), documentFormat);
    }

    @Override
    public DocumentFormat getFormatBySuffix(String suffix) {
        return null == suffix ? null : this.fmtsByExtension.get(StringKit.lowerCase(suffix));
    }

    @Override
    public DocumentFormat getFormatByMimeType(String mimeType) {
        return null == mimeType ? null : this.fmtsByMimeType.get(StringKit.lowerCase(mimeType));
    }

    @Override
    public Set<DocumentFormat> getOutputFormats(FamilyType family) {
        return Optional.ofNullable(family).map(docFam -> this.fmtsByMimeType.values().stream().filter(format -> null != format.getStoreProperties((FamilyType)((Object)docFam))).collect(Collectors.toSet())).orElse(new HashSet());
    }
}

