/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.aoju.bus.office.support.excel.sax.ExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.RowHandler;
import org.aoju.bus.office.support.excel.sax.SheetRidReader;
import org.aoju.bus.office.support.excel.sax.SheetSaxHandler;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;

public class Excel07SaxReader
implements ExcelSaxReader<Excel07SaxReader> {
    private final SheetSaxHandler handler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.handler = new SheetSaxHandler(rowHandler);
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.handler.setRowHandler(rowHandler);
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws InstrumentException {
        return this.read(file, "rId" + rid);
    }

    @Override
    public Excel07SaxReader read(File file, String idOrRidOrSheetName) throws InstrumentException {
        Excel07SaxReader excel07SaxReader;
        block8: {
            OPCPackage open = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
            try {
                excel07SaxReader = this.read(open, idOrRidOrSheetName);
                if (open == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (open != null) {
                        try {
                            open.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidFormatException e) {
                    throw new InstrumentException(e);
                }
            }
            open.close();
        }
        return excel07SaxReader;
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws InstrumentException {
        return this.read(in, "rId" + rid);
    }

    @Override
    public Excel07SaxReader read(InputStream in, String idOrRidOrSheetName) throws InstrumentException {
        Excel07SaxReader excel07SaxReader;
        block9: {
            OPCPackage opcPackage = OPCPackage.open((InputStream)in);
            try {
                excel07SaxReader = this.read(opcPackage, idOrRidOrSheetName);
                if (opcPackage == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (opcPackage != null) {
                        try {
                            opcPackage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InstrumentException(e);
                }
                catch (InvalidFormatException e) {
                    throw new InstrumentException(e);
                }
            }
            opcPackage.close();
        }
        return excel07SaxReader;
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws InstrumentException {
        return this.read(opcPackage, "rId" + rid);
    }

    public Excel07SaxReader read(OPCPackage opcPackage, String idOrRidOrSheetName) throws InstrumentException {
        try {
            return this.read(new XSSFReader(opcPackage), idOrRidOrSheetName);
        }
        catch (OpenXML4JException e) {
            throw new InstrumentException(e);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public Excel07SaxReader read(XSSFReader xssfReader, String idOrRidOrSheetName) throws InstrumentException {
        try {
            this.handler.stylesTable = xssfReader.getStylesTable();
        }
        catch (IOException | InvalidFormatException throwable) {
            // empty catch block
        }
        this.handler.sharedStrings = (SharedStrings)ReflectKit.invoke((Object)xssfReader, "getSharedStringsTable", new Object[0]);
        return this.readSheets(xssfReader, idOrRidOrSheetName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Excel07SaxReader readSheets(XSSFReader xssfReader, String idOrRidOrSheetName) throws InstrumentException {
        this.handler.sheetIndex = this.getSheetIndex(xssfReader, idOrRidOrSheetName);
        InputStream sheetInputStream = null;
        try {
            if (this.handler.sheetIndex > -1) {
                sheetInputStream = xssfReader.getSheet("rId" + (this.handler.sheetIndex + 1));
                ExcelSaxKit.readFrom(sheetInputStream, this.handler);
                this.handler.rowHandler.doAfterAllAnalysed();
            } else {
                this.handler.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.handler.index = 0;
                    ++this.handler.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxKit.readFrom(sheetInputStream, this.handler);
                    this.handler.rowHandler.doAfterAllAnalysed();
                }
            }
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new InstrumentException(e2);
                }
            }
            catch (Throwable throwable) {
                IoKit.close(sheetInputStream);
                throw throwable;
            }
        }
        IoKit.close(sheetInputStream);
        return this;
    }

    private int getSheetIndex(XSSFReader xssfReader, String idOrRidOrSheetName) {
        if (StringKit.startWithIgnoreCase(idOrRidOrSheetName, "rId")) {
            return Integer.parseInt(StringKit.removePrefixIgnoreCase(idOrRidOrSheetName, "rId"));
        }
        SheetRidReader ridReader = SheetRidReader.parse(xssfReader);
        if (StringKit.startWithIgnoreCase(idOrRidOrSheetName, "sheetName:")) {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName = StringKit.removePrefixIgnoreCase(idOrRidOrSheetName, "sheetName:"));
            if (null != rid) {
                return rid;
            }
        } else {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName);
            if (null != rid) {
                return rid;
            }
            try {
                int sheetIndex = Integer.parseInt(idOrRidOrSheetName);
                rid = ridReader.getRidBySheetIdBase0(sheetIndex);
                return ObjectKit.defaultIfNull(rid, sheetIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid rId or id or sheetName: " + idOrRidOrSheetName);
    }
}

