/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.proxy;

import java.util.Properties;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.PageContext;
import org.aoju.bus.pager.Paging;
import org.aoju.bus.pager.RowBounds;
import org.aoju.bus.pager.proxy.PageObject;

public class PageParams {
    protected boolean offsetAsPageNo = false;
    protected boolean rowBoundsWithCount = false;
    protected boolean pageSizeZero = false;
    protected boolean reasonable = false;
    protected boolean supportMethodsArguments = false;
    protected String countColumn = "0";

    public Page getPage(Object parameterObject, org.apache.ibatis.session.RowBounds rowBounds) {
        Page<Object> page = PageContext.getLocalPage();
        if (null == page) {
            if (rowBounds != org.apache.ibatis.session.RowBounds.DEFAULT) {
                if (this.offsetAsPageNo) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
                if (rowBounds instanceof RowBounds) {
                    RowBounds pageRowBounds = (RowBounds)rowBounds;
                    page.setCount(pageRowBounds.getCount() == null || pageRowBounds.getCount() != false);
                }
            } else if (parameterObject instanceof Paging || this.supportMethodsArguments) {
                try {
                    page = PageObject.getPageFromObject(parameterObject, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (null == page) {
                return null;
            }
            PageContext.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public void setProperties(Properties properties) {
        this.offsetAsPageNo = Boolean.parseBoolean(properties.getProperty("offsetAsPageNo"));
        String rowBoundsWithCount = properties.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = properties.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = properties.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = properties.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        String countColumn = properties.getProperty("countColumn");
        if (StringKit.isNotEmpty(countColumn)) {
            this.countColumn = countColumn;
        }
        PageObject.setParams(properties.getProperty("params"));
    }

    public boolean isOffsetAsPageNo() {
        return this.offsetAsPageNo;
    }

    public boolean isRowBoundsWithCount() {
        return this.rowBoundsWithCount;
    }

    public boolean isPageSizeZero() {
        return this.pageSizeZero;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean isSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public String getCountColumn() {
        return this.countColumn;
    }
}

