/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.alipay;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pay.Context;

public class AliPayKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, Context> CFG_MAP = new ConcurrentHashMap<String, Context>();
    private static final String DEFAULT_CFG_KEY = "_default_key_";

    public static Context putApiConfig(Context context) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, context);
        }
        return CFG_MAP.put(Context.getAppId(), context);
    }

    public static Context setThreadLocalAliPayApiConfig(Context context) {
        if (StringKit.isNotEmpty(Context.getAppId())) {
            AliPayKit.setThreadLocalAppId(Context.getAppId());
        }
        return AliPayKit.putApiConfig(context);
    }

    public static Context removeApiConfig(Context context) {
        return AliPayKit.removeApiConfig(Context.getAppId());
    }

    public static Context removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StringKit.isEmpty(appId)) {
            CFG_MAP.get(DEFAULT_CFG_KEY);
            appId = Context.getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StringKit.isEmpty(appId)) {
            CFG_MAP.get(DEFAULT_CFG_KEY);
            appId = Context.getAppId();
        }
        return appId;
    }

    public static Context getAliPayApiConfig() {
        String appId = AliPayKit.getAppId();
        return AliPayKit.getApiConfig(appId);
    }

    public static Context getApiConfig(String appId) {
        Context context = CFG_MAP.get(appId);
        if (context == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 AliPayApiConfigKit.putApiConfig(aliPayApiConfig) \u5c06 appId\u5bf9\u5e94\u7684 aliPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 AliPayApiConfigKit.getAliPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return context;
    }
}

