/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.oauth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.metric.OauthCache;
import org.aoju.bus.oauth.provider.AlipayProvider;
import org.aoju.bus.oauth.provider.BaiduProvider;
import org.aoju.bus.oauth.provider.CodingProvider;
import org.aoju.bus.oauth.provider.DingTalkProvider;
import org.aoju.bus.oauth.provider.DouyinProvider;
import org.aoju.bus.oauth.provider.ElemeProvider;
import org.aoju.bus.oauth.provider.FacebookProvider;
import org.aoju.bus.oauth.provider.GiteeProvider;
import org.aoju.bus.oauth.provider.GithubProvider;
import org.aoju.bus.oauth.provider.GitlabProvider;
import org.aoju.bus.oauth.provider.GoogleProvider;
import org.aoju.bus.oauth.provider.HuaweiProvider;
import org.aoju.bus.oauth.provider.JdProvider;
import org.aoju.bus.oauth.provider.KujialeProvider;
import org.aoju.bus.oauth.provider.LinkedinProvider;
import org.aoju.bus.oauth.provider.MeituanProvider;
import org.aoju.bus.oauth.provider.MicrosoftProvider;
import org.aoju.bus.oauth.provider.OschinaProvider;
import org.aoju.bus.oauth.provider.PinterestProvider;
import org.aoju.bus.oauth.provider.QqProvider;
import org.aoju.bus.oauth.provider.StackOverflowProvider;
import org.aoju.bus.oauth.provider.TaobaoProvider;
import org.aoju.bus.oauth.provider.TeambitionProvider;
import org.aoju.bus.oauth.provider.TencentProvider;
import org.aoju.bus.oauth.provider.ToutiaoProvider;
import org.aoju.bus.oauth.provider.TwitterProvider;
import org.aoju.bus.oauth.provider.WeChatEEProvider;
import org.aoju.bus.oauth.provider.WeChatMaProvider;
import org.aoju.bus.oauth.provider.WeChatMpProvider;
import org.aoju.bus.oauth.provider.WeChatOPProvider;
import org.aoju.bus.oauth.provider.WeiboProvider;
import org.aoju.bus.oauth.provider.XiaomiProvider;
import org.aoju.bus.starter.oauth.AuthProperties;

public class AuthProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public AuthProperties properties;
    public ExtendCache extendCache;

    public AuthProviderService(AuthProperties properties) {
        this(properties, OauthCache.INSTANCE);
    }

    public AuthProviderService(AuthProperties properties, ExtendCache extendCache) {
        this.properties = properties;
        this.extendCache = extendCache;
    }

    public static void register(Registry type, Context context) {
        if (CACHE.containsKey(type)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + type.name());
        }
        CACHE.putIfAbsent(type, context);
    }

    public Provider require(Registry type) {
        Context context = CACHE.get(type);
        if (ObjectKit.isEmpty(context)) {
            context = this.properties.getType().get(type);
        }
        if (Registry.ALIPAY.equals(type)) {
            return new AlipayProvider(context, this.extendCache);
        }
        if (Registry.BAIDU.equals(type)) {
            return new BaiduProvider(context, this.extendCache);
        }
        if (Registry.CODING.equals(type)) {
            return new CodingProvider(context, this.extendCache);
        }
        if (Registry.DINGTALK.equals(type)) {
            return new DingTalkProvider(context, this.extendCache);
        }
        if (Registry.DOUYIN.equals(type)) {
            return new DouyinProvider(context, this.extendCache);
        }
        if (Registry.ELEME.equals(type)) {
            return new ElemeProvider(context, this.extendCache);
        }
        if (Registry.FACEBOOK.equals(type)) {
            return new FacebookProvider(context, this.extendCache);
        }
        if (Registry.GITEE.equals(type)) {
            return new GiteeProvider(context, this.extendCache);
        }
        if (Registry.GITHUB.equals(type)) {
            return new GithubProvider(context, this.extendCache);
        }
        if (Registry.GITLAB.equals(type)) {
            return new GitlabProvider(context, this.extendCache);
        }
        if (Registry.GOOGLE.equals(type)) {
            return new GoogleProvider(context, this.extendCache);
        }
        if (Registry.HUAWEI.equals(type)) {
            return new HuaweiProvider(context, this.extendCache);
        }
        if (Registry.JD.equals(type)) {
            return new JdProvider(context, this.extendCache);
        }
        if (Registry.KUJIALE.equals(type)) {
            return new KujialeProvider(context, this.extendCache);
        }
        if (Registry.LINKEDIN.equals(type)) {
            return new LinkedinProvider(context, this.extendCache);
        }
        if (Registry.MEITUAN.equals(type)) {
            return new MeituanProvider(context, this.extendCache);
        }
        if (Registry.MICROSOFT.equals(type)) {
            return new MicrosoftProvider(context, this.extendCache);
        }
        if (Registry.XIAOMI.equals(type)) {
            return new XiaomiProvider(context, this.extendCache);
        }
        if (Registry.OSCHINA.equals(type)) {
            return new OschinaProvider(context, this.extendCache);
        }
        if (Registry.PINTEREST.equals(type)) {
            return new PinterestProvider(context, this.extendCache);
        }
        if (Registry.QQ.equals(type)) {
            return new QqProvider(context, this.extendCache);
        }
        if (Registry.STACKOVERFLOW.equals(type)) {
            return new StackOverflowProvider(context, this.extendCache);
        }
        if (Registry.TAOBAO.equals(type)) {
            return new TaobaoProvider(context, this.extendCache);
        }
        if (Registry.TEAMBITION.equals(type)) {
            return new TeambitionProvider(context, this.extendCache);
        }
        if (Registry.TENCENT.equals(type)) {
            return new TencentProvider(context, this.extendCache);
        }
        if (Registry.TOUTIAO.equals(type)) {
            return new ToutiaoProvider(context, this.extendCache);
        }
        if (Registry.TWITTER.equals(type)) {
            return new TwitterProvider(context, this.extendCache);
        }
        if (Registry.WECHAT_EE.equals(type)) {
            return new WeChatEEProvider(context, this.extendCache);
        }
        if (Registry.WECHAT_MP.equals(type)) {
            return new WeChatMpProvider(context, this.extendCache);
        }
        if (Registry.WECHAT_MA.equals(type)) {
            return new WeChatMaProvider(context, this.extendCache);
        }
        if (Registry.WECHAT_OP.equals(type)) {
            return new WeChatOPProvider(context, this.extendCache);
        }
        if (Registry.WEIBO.equals(type)) {
            return new WeiboProvider(context, this.extendCache);
        }
        throw new InstrumentException(Builder.ErrorCode.UNSUPPORTED.getMsg());
    }
}

