/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.tracer;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.aoju.bus.tracer.config.TraceFilterConfig;

public class TracerProperties {
    private int sessionIdLength = 32;
    private int invocationIdLength = 32;
    private Map<TraceFilterConfig.Channel, Pattern> filter = new HashMap<TraceFilterConfig.Channel, Pattern>();
    private Map<String, Profile> profile = new HashMap<String, Profile>();
    private TraceFilterConfig delegate = new TraceFilterConfig(){

        @Override
        public boolean shouldProcessParam(String paramName, TraceFilterConfig.Channel channel) {
            return true;
        }

        @Override
        public Map<String, String> filterDeniedParams(Map<String, String> unfiltered, TraceFilterConfig.Channel channel) {
            return unfiltered;
        }

        @Override
        public boolean shouldProcessContext(TraceFilterConfig.Channel channel) {
            return true;
        }

        @Override
        public boolean shouldGenerateInvocationId() {
            return TracerProperties.this.invocationIdLength > 0;
        }

        @Override
        public int generatedInvocationIdLength() {
            return TracerProperties.this.invocationIdLength;
        }

        @Override
        public boolean shouldGenerateSessionId() {
            return TracerProperties.this.sessionIdLength > 0;
        }

        @Override
        public int generatedSessionIdLength() {
            return TracerProperties.this.sessionIdLength;
        }
    };

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public int getInvocationIdLength() {
        return this.invocationIdLength;
    }

    public void setInvocationIdLength(int invocationIdLength) {
        this.invocationIdLength = invocationIdLength;
    }

    public Map<TraceFilterConfig.Channel, Pattern> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<TraceFilterConfig.Channel, Pattern> filter) {
        this.filter = filter;
    }

    public Map<String, Profile> getProfile() {
        return this.profile;
    }

    public void setProfile(Map<String, Profile> profile) {
        this.profile = profile;
    }

    public TraceFilterConfig getAsFilterConfiguration() {
        return this.delegate;
    }

    public static class Profile {
        private Map<TraceFilterConfig.Channel, Pattern> filter;

        public Map<TraceFilterConfig.Channel, Pattern> getFilter() {
            return this.filter;
        }

        public void setFilter(Map<TraceFilterConfig.Channel, Pattern> filter) {
            this.filter = filter;
        }
    }
}

