/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.builder.DifferentBuilder;
import org.aoju.bus.core.builder.DifferentResult;
import org.aoju.bus.core.builder.ToStringStyle;
import org.aoju.bus.core.toolkit.ClassKit;

public class ReflectionBuilder
implements Builder<DifferentResult> {
    private final Object left;
    private final Object right;
    private final DifferentBuilder differentBuilder;

    public <T> ReflectionBuilder(T lhs, T rhs, ToStringStyle style) {
        this.left = lhs;
        this.right = rhs;
        this.differentBuilder = new DifferentBuilder(lhs, rhs, style);
    }

    @Override
    public DifferentResult build() {
        if (this.left.equals(this.right)) {
            return this.differentBuilder.build();
        }
        this.appendFields(this.left.getClass());
        return this.differentBuilder.build();
    }

    private void appendFields(Class<?> clazz) {
        for (Field field : ClassKit.getAllFields(clazz)) {
            if (!this.accept(field)) continue;
            try {
                this.differentBuilder.append(field.getName(), ClassKit.readField(field, this.left, true), ClassKit.readField(field, this.right, true));
            }
            catch (IllegalAccessException ex) {
                throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
            }
        }
    }

    private boolean accept(Field field) {
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic(field.getModifiers());
    }
}

