/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compress;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;

    public ZipWriter(File zipFile, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(zipFile, charset);
    }

    public ZipWriter(OutputStream out, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(out, charset);
    }

    public ZipWriter(ZipOutputStream out) {
        this.out = out;
    }

    public static ZipWriter of(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter of(OutputStream out, Charset charset) {
        return new ZipWriter(out, charset);
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipWriter.getZipOutputStream(FileKit.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, charset);
    }

    public ZipWriter setLevel(int level) {
        this.out.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment) {
        this.out.setComment(comment);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter add(Resource ... resources) throws InternalException {
        for (Resource resource : resources) {
            if (null == resource) continue;
            this.add(resource.getName(), resource.getStream());
        }
        return this;
    }

    public ZipWriter add(String path, InputStream in) throws InternalException {
        path = StringKit.nullToEmpty(path);
        if (null == in && StringKit.isBlank(path = StringKit.addSuffixIfNot(path, "/"))) {
            return this;
        }
        return this.putEntry(path, in);
    }

    public ZipWriter add(String[] paths, InputStream[] ins) throws InternalException {
        if (ArrayKit.isEmpty(paths) || ArrayKit.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        for (int i = 0; i < paths.length; ++i) {
            this.add(paths[i], ins[i]);
        }
        return this;
    }

    public ZipWriter add(boolean withSrcDir, FileFilter filter, File ... files) throws InternalException {
        for (File file : files) {
            String srcRootDir;
            try {
                srcRootDir = file.getCanonicalPath();
                if (!file.isDirectory() || withSrcDir) {
                    srcRootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
            this._add(file, srcRootDir, filter);
        }
        return this;
    }

    @Override
    public void close() throws InternalException {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            IoKit.close(this.out);
        }
    }

    private ZipWriter _add(File file, String srcRootDir, FileFilter filter) throws InternalException {
        if (null == file || null != filter && !filter.accept(file)) {
            return this;
        }
        String subPath = FileKit.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayKit.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (File childFile : files) {
                    this._add(childFile, srcRootDir, filter);
                }
            }
        } else {
            this.putEntry(subPath, FileKit.getInputStream(file));
        }
        return this;
    }

    private ZipWriter putEntry(String path, InputStream in) throws InternalException {
        try {
            this.out.putNextEntry(new ZipEntry(path));
            if (null != in) {
                IoKit.copy(in, this.out);
            }
            this.out.closeEntry();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            IoKit.close(in);
        }
        IoKit.flush(this.out);
        return this;
    }
}

