/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.aoju.bus.core.convert.ArrayConverter;
import org.aoju.bus.core.convert.AtomicBooleanConverter;
import org.aoju.bus.core.convert.AtomicIntegerArrayConverter;
import org.aoju.bus.core.convert.AtomicLongArrayConverter;
import org.aoju.bus.core.convert.AtomicReferenceConverter;
import org.aoju.bus.core.convert.BeanConverter;
import org.aoju.bus.core.convert.BooleanConverter;
import org.aoju.bus.core.convert.CalendarConverter;
import org.aoju.bus.core.convert.CharacterConverter;
import org.aoju.bus.core.convert.CharsetConverter;
import org.aoju.bus.core.convert.ClassConverter;
import org.aoju.bus.core.convert.CollectionConverter;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.convert.CurrencyConverter;
import org.aoju.bus.core.convert.DateConverter;
import org.aoju.bus.core.convert.DurationConverter;
import org.aoju.bus.core.convert.EnumConverter;
import org.aoju.bus.core.convert.LocaleConverter;
import org.aoju.bus.core.convert.MapConverter;
import org.aoju.bus.core.convert.NumberConverter;
import org.aoju.bus.core.convert.OptionalConverter;
import org.aoju.bus.core.convert.PathConverter;
import org.aoju.bus.core.convert.PeriodConverter;
import org.aoju.bus.core.convert.PrimitiveConverter;
import org.aoju.bus.core.convert.ReferenceConverter;
import org.aoju.bus.core.convert.StackTraceConverter;
import org.aoju.bus.core.convert.StringConverter;
import org.aoju.bus.core.convert.TemporalConverter;
import org.aoju.bus.core.convert.TimeZoneConverter;
import org.aoju.bus.core.convert.URIConverter;
import org.aoju.bus.core.convert.URLConverter;
import org.aoju.bus.core.convert.UUIDConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class ConverterRegistry {
    private Map<Type, Converter<?>> defaultMap;
    private volatile Map<Type, Converter<?>> customMap;

    public ConverterRegistry() {
        this.defaultConverter();
    }

    public static ConverterRegistry getInstance() {
        return SingletonHolder.instance;
    }

    public ConverterRegistry putCustom(Type type, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(type, ReflectKit.newInstance(converterClass, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter<?> converter) {
        if (null == this.customMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customMap) {
                    this.customMap = new ConcurrentHashMap();
                }
            }
        }
        this.customMap.put(type, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Type type, boolean isCustomFirst) {
        Converter<T> converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Type type) {
        return null == this.defaultMap ? null : this.defaultMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Type type) {
        return null == this.customMap ? null : this.customMap.get(type);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter<T> converter;
        if (TypeKit.isUnknown(type) && null == defaultValue) {
            return (T)value;
        }
        if (ObjectKit.isNull(value)) {
            return defaultValue;
        }
        if (TypeKit.isUnknown(type)) {
            type = defaultValue.getClass();
        }
        if (type instanceof Types) {
            type = ((Types)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(value, defaultValue);
        }
        Class<?> rowType = TypeKit.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                return (T)value;
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (BeanKit.isBean(rowType)) {
            return new BeanConverter<T>(type).convert(value, defaultValue);
        }
        throw new ConvertException("No Converter for type [{}]", new Object[]{rowType.getName()});
    }

    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            CollectionConverter collectionConverter = new CollectionConverter(type);
            return (T)collectionConverter.convert(value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            MapConverter mapConverter = new MapConverter(type);
            return (T)mapConverter.convert(value, (Map)defaultValue);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isEnum()) {
            return new EnumConverter(rowType).convert(value, defaultValue);
        }
        if (rowType.isArray()) {
            ArrayConverter arrayConverter = new ArrayConverter(rowType);
            try {
                return arrayConverter.convert(value, defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private ConverterRegistry defaultConverter() {
        this.defaultMap = new ConcurrentHashMap();
        this.defaultMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultMap.put((Type)((Object)Number.class), new NumberConverter());
        this.defaultMap.put((Type)((Object)Integer.class), new NumberConverter(Integer.class));
        this.defaultMap.put((Type)((Object)AtomicInteger.class), new NumberConverter(AtomicInteger.class));
        this.defaultMap.put((Type)((Object)Long.class), new NumberConverter(Long.class));
        this.defaultMap.put((Type)((Object)LongAdder.class), new NumberConverter(LongAdder.class));
        this.defaultMap.put((Type)((Object)AtomicLong.class), new NumberConverter(AtomicLong.class));
        this.defaultMap.put((Type)((Object)Byte.class), new NumberConverter(Byte.class));
        this.defaultMap.put((Type)((Object)Short.class), new NumberConverter(Short.class));
        this.defaultMap.put((Type)((Object)Float.class), new NumberConverter(Float.class));
        this.defaultMap.put((Type)((Object)Double.class), new NumberConverter(Double.class));
        this.defaultMap.put((Type)((Object)DoubleAdder.class), new NumberConverter(DoubleAdder.class));
        this.defaultMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultMap.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        this.defaultMap.put((Type)((Object)BigDecimal.class), new NumberConverter(BigDecimal.class));
        this.defaultMap.put((Type)((Object)BigInteger.class), new NumberConverter(BigInteger.class));
        this.defaultMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultMap.put((Type)((Object)URI.class), new URIConverter());
        this.defaultMap.put((Type)((Object)URL.class), new URLConverter());
        this.defaultMap.put((Type)((Object)Calendar.class), new CalendarConverter());
        this.defaultMap.put((Type)((Object)Date.class), new DateConverter(Date.class));
        this.defaultMap.put((Type)((Object)DateTime.class), new DateConverter(DateTime.class));
        this.defaultMap.put((Type)((Object)java.sql.Date.class), new DateConverter(java.sql.Date.class));
        this.defaultMap.put((Type)((Object)Time.class), new DateConverter(Time.class));
        this.defaultMap.put((Type)((Object)Timestamp.class), new DateConverter(Timestamp.class));
        this.defaultMap.put((Type)((Object)TemporalAccessor.class), new TemporalConverter(Instant.class));
        this.defaultMap.put((Type)((Object)Instant.class), new TemporalConverter(Instant.class));
        this.defaultMap.put((Type)((Object)LocalDateTime.class), new TemporalConverter(LocalDateTime.class));
        this.defaultMap.put((Type)((Object)LocalDate.class), new TemporalConverter(LocalDate.class));
        this.defaultMap.put((Type)((Object)LocalTime.class), new TemporalConverter(LocalTime.class));
        this.defaultMap.put((Type)((Object)ZonedDateTime.class), new TemporalConverter(ZonedDateTime.class));
        this.defaultMap.put((Type)((Object)OffsetDateTime.class), new TemporalConverter(OffsetDateTime.class));
        this.defaultMap.put((Type)((Object)OffsetTime.class), new TemporalConverter(OffsetTime.class));
        this.defaultMap.put((Type)((Object)DayOfWeek.class), new TemporalConverter(DayOfWeek.class));
        this.defaultMap.put((Type)((Object)Month.class), new TemporalConverter(Month.class));
        this.defaultMap.put((Type)((Object)MonthDay.class), new TemporalConverter(MonthDay.class));
        this.defaultMap.put((Type)((Object)Period.class), new PeriodConverter());
        this.defaultMap.put((Type)((Object)Duration.class), new DurationConverter());
        this.defaultMap.put((Type)((Object)WeakReference.class), new ReferenceConverter(WeakReference.class));
        this.defaultMap.put((Type)((Object)SoftReference.class), new ReferenceConverter(SoftReference.class));
        this.defaultMap.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        this.defaultMap.put((Type)((Object)AtomicIntegerArray.class), new AtomicIntegerArrayConverter());
        this.defaultMap.put((Type)((Object)AtomicLongArray.class), new AtomicLongArrayConverter());
        this.defaultMap.put((Type)((Object)Class.class), new ClassConverter());
        this.defaultMap.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        this.defaultMap.put((Type)((Object)Locale.class), new LocaleConverter());
        this.defaultMap.put((Type)((Object)Charset.class), new CharsetConverter());
        this.defaultMap.put((Type)((Object)Path.class), new PathConverter());
        this.defaultMap.put((Type)((Object)Currency.class), new CurrencyConverter());
        this.defaultMap.put((Type)((Object)UUID.class), new UUIDConverter());
        this.defaultMap.put((Type)((Object)StackTraceElement.class), new StackTraceConverter());
        this.defaultMap.put((Type)((Object)Optional.class), new OptionalConverter());
        this.defaultMap.put((Type)((Object)Optional.class), new OptionalConverter());
        return this;
    }

    private static class SingletonHolder {
        private static final ConverterRegistry instance = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

