/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aoju.bus.core.date.Between;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.Formatter;
import org.aoju.bus.core.date.Solar;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.ZoneId;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Almanac
extends Converter {
    public static int getYear(Date date) {
        return Converter.toLocalDateTime(date).getYear();
    }

    public static int getYear(Instant instant) {
        return Converter.toLocalDateTime(instant).getYear();
    }

    public static int getYear(LocalDateTime localDateTime) {
        return localDateTime.getYear();
    }

    public static int getYear(LocalDate localDate) {
        return localDate.getYear();
    }

    public static List<String> getYear(String startDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            Date date1 = df.parse(startDate);
            Date date2 = df.parse(endDate);
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            list.add(df.format(date1));
            c1.setTime(date1);
            c2.setTime(date2);
            while (c1.compareTo(c2) < 0) {
                c1.add(1, 1);
                Date ss = c1.getTime();
                String text = df.format(ss);
                list.add(text);
            }
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return list;
    }

    private static String getQuarter(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }

    public static LinkedHashSet<String> getQuarter(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            return new LinkedHashSet<String>(0);
        }
        return Almanac.getQuarter(startDate.getTime(), endDate.getTime());
    }

    public static LinkedHashSet<String> getQuarter(long startDate, long endDate) {
        LinkedHashSet<String> quarters = new LinkedHashSet<String>();
        Calendar cal = Almanac.toCalendar(startDate);
        while (startDate <= endDate) {
            quarters.add(Almanac.getQuarter(cal));
            cal.add(2, 3);
            startDate = cal.getTimeInMillis();
        }
        return quarters;
    }

    public static Map<String, String> getQuarter(int type, String beginkey, String endkey, String beginWkey, String endWkey, String begin, String end, String beginW, String endW) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            calBegin.set(2, Almanac.getMonthOfQuarter(Integer.parseInt(beginW)));
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calEnd.set(2, Almanac.getMonthOfQuarter(Integer.parseInt(endW)));
            if (type == 1) {
                int quarter = ((Integer.parseInt(end) - Integer.parseInt(begin)) * 4 + (Integer.parseInt(endW) - Integer.parseInt(beginW)) + 1) * 3;
                calBegin.add(2, -quarter);
                calEnd.add(2, -quarter);
                map.put(beginWkey, String.valueOf(Almanac.getQuarterOfMonth(calBegin.get(2))));
                map.put(endWkey, String.valueOf(Almanac.getQuarterOfMonth(calEnd.get(2))));
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
                map.put(beginWkey, beginW);
                map.put(endWkey, endW);
            }
            map.put(beginkey, calBegin.get(1) + "-" + Almanac.getMonthOfQuarter(0, Integer.parseInt((String)map.get(beginWkey))));
            map.put(endkey, calEnd.get(1) + "-" + Almanac.getMonthOfQuarter(1, Integer.parseInt((String)map.get(endWkey))));
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return map;
    }

    public static List<String> getQuarter(String StartDate, String beginQ, String endDate, String endQ) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date date1 = sdf.parse(StartDate);
            Date dEnd = sdf.parse(endDate);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            ArrayList<String> list = new ArrayList<String>();
            int beginY = calBegin.get(1);
            int beginYQ = Integer.parseInt(beginQ);
            int endY = calEnd.get(1);
            int endYQ = Integer.parseInt(endQ);
            while (true) {
                list.add(beginY + "\u5e74\u7b2c" + beginYQ + "\u5b63\u5ea6");
                if (beginY == endY && beginYQ == endYQ) {
                    return list;
                }
                if (++beginYQ <= 4) continue;
                beginYQ = 1;
                ++beginY;
            }
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
    }

    public static String getMonth(int month) {
        return Fields.CN_MONTH[month - 1];
    }

    public static int getMonth(Date date) {
        return Converter.toLocalDateTime(date).getMonthValue();
    }

    public static int getMonth(Instant instant) {
        return Converter.toLocalDateTime(instant).getMonthValue();
    }

    public static int getMonth(LocalDateTime localDateTime) {
        return localDateTime.getMonthValue();
    }

    public static int getMonth(LocalDate localDate) {
        return localDate.getMonthValue();
    }

    public static List<String> getMonth(String startDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            Date date1 = df.parse(startDate);
            Date date2 = df.parse(endDate);
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            list.add(df.format(date1));
            c1.setTime(date1);
            c2.setTime(date2);
            while (c1.compareTo(c2) < 0) {
                c1.add(2, 1);
                Date ss = c1.getTime();
                String text = df.format(ss);
                list.add(text);
            }
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return list;
    }

    public static Map<String, String> getMonth(int type, String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            if (type == 1) {
                int year = calBegin.get(1);
                int month = calBegin.get(2);
                int year1 = calEnd.get(1);
                int month1 = calEnd.get(2);
                int result = year == year1 ? month1 - month : 12 * (year1 - year) + month1 - month;
                calBegin.add(2, -(++result));
                calEnd.add(2, -result);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
            }
            map.put(beginkey, sdf.format(calBegin.getTime()));
            map.put(endkey, sdf.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return map;
    }

    public static String getMonthEnLong(Date date) {
        return Fields.Month.getFullNameEnByCode(Almanac.getMonth(date));
    }

    public static String getMonthEnLong(Instant instant) {
        return Fields.Month.getFullNameEnByCode(Almanac.getMonth(instant));
    }

    public static String getMonthEnLong(LocalDateTime localDateTime) {
        return Fields.Month.getFullNameEnByCode(Almanac.getMonth(localDateTime));
    }

    public static String getMonthEnLong(LocalDate localDate) {
        return Fields.Month.getFullNameEnByCode(Almanac.getMonth(localDate));
    }

    public static String getMonthEnShort(Date date) {
        return Fields.Month.getFullNameEnByCode(Almanac.getMonth(date));
    }

    public static String getMonthEnShort(Instant instant) {
        return Fields.Month.getShortNameEnByCode(Almanac.getMonth(instant));
    }

    public static String getMonthEnShort(LocalDateTime localDateTime) {
        return Fields.Month.getShortNameEnByCode(Almanac.getMonth(localDateTime));
    }

    public static String getMonthEnShort(LocalDate localDate) {
        return Fields.Month.getShortNameEnByCode(localDate.getMonthValue());
    }

    public static String getMonthEnShortUpper(Date date) {
        return Fields.Month.getShortNameEnByCode(Almanac.getMonth(date)).toUpperCase();
    }

    public static String getMonthEnShortUpper(Instant instant) {
        return Fields.Month.getShortNameEnByCode(Almanac.getMonth(instant)).toUpperCase();
    }

    public static String getMonthEnShortUpper(LocalDateTime localDateTime) {
        return Fields.Month.getShortNameEnByCode(Almanac.getMonth(localDateTime)).toUpperCase();
    }

    public static String getMonthEnShortUpper(LocalDate localDate) {
        return Fields.Month.getShortNameEnByCode(localDate.getMonthValue()).toUpperCase();
    }

    public static String getMonthCnLong(Date date) {
        return Fields.Month.getFullNameCnByCode(Almanac.getMonth(date));
    }

    public static String getMonthCnLong(Instant instant) {
        return Fields.Month.getFullNameCnByCode(Almanac.getMonth(instant));
    }

    public static String getMonthCnLong(LocalDateTime localDateTime) {
        return Fields.Month.getFullNameCnByCode(Almanac.getMonth(localDateTime));
    }

    public static String getMonthCnLong(LocalDate localDate) {
        return Fields.Month.getFullNameCnByCode(localDate.getMonthValue());
    }

    public static String getMonthCnShort(Date date) {
        return Fields.Month.getShortNameCnByCode(Almanac.getMonth(date));
    }

    public static String getMonthCnShort(Instant instant) {
        return Fields.Month.getShortNameCnByCode(Almanac.getMonth(instant));
    }

    public static String getMonthCnShort(LocalDateTime localDateTime) {
        return Fields.Month.getShortNameCnByCode(Almanac.getMonth(localDateTime));
    }

    public static String getMonthCnShort(LocalDate localDate) {
        return Fields.Month.getShortNameCnByCode(localDate.getMonthValue());
    }

    public static int getMonthOfQuarter(int quarter) {
        if (quarter == 1) {
            return 1;
        }
        if (quarter == 2) {
            return 4;
        }
        if (quarter == 3) {
            return 7;
        }
        if (quarter == 4) {
            return 10;
        }
        return 1;
    }

    public static String getMonthOfQuarter(int type, int quarter) {
        if (quarter == 1) {
            if (type == 1) {
                return "03";
            }
            return "01";
        }
        if (quarter == 2) {
            if (type == 1) {
                return "06";
            }
            return "04";
        }
        if (quarter == 3) {
            if (type == 1) {
                return "09";
            }
            return "07";
        }
        if (quarter == 4) {
            if (type == 1) {
                return "12";
            }
            return "10";
        }
        return "01";
    }

    public static int getQuarterOfMonth(int month) {
        int quarter = 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        if (month >= 10 && month <= 12) {
            return 4;
        }
        return quarter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getWeek(String begin, String end, String startw, String endW) {
        ArrayList<String> lDate = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calBegin.setFirstDayOfWeek(2);
            int beginww = Integer.parseInt(startw);
            int endww = Integer.parseInt(endW);
            int beginY = calBegin.get(1);
            int endY = calEnd.get(1);
            int weekall = Almanac.getWeek("" + beginY);
            do {
                lDate.add(beginY + "\u5e74\u7b2c" + beginww + "\u5468");
                if (beginww == weekall) {
                    beginww = 0;
                    weekall = Almanac.getWeek("" + ++beginY);
                }
                if (beginY == endY && beginww == endww) return lDate;
                ++beginww;
            } while (beginY <= endY);
            return lDate;
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
    }

    public static int getWeek(String year) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(Fields.PURE_DATETIME_FORMAT.parse(year + "-12-31"));
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        calendar.setFirstDayOfWeek(2);
        int week = calendar.get(3);
        if (week != 53) {
            week = 52;
        }
        return week;
    }

    public static int getWeek(Date start, Date end) {
        Calendar c_begin = Calendar.getInstance();
        c_begin.setTime(start);
        Calendar c_end = Calendar.getInstance();
        c_end.setTime(end);
        int count = 0;
        c_begin.setFirstDayOfWeek(2);
        c_end.setFirstDayOfWeek(2);
        while (c_begin.before(c_end)) {
            if (c_begin.get(7) == 1) {
                ++count;
            }
            c_begin.add(6, 1);
        }
        return count;
    }

    public static String getDayOfMonth(int lunarDay) {
        return Fields.CN_DAY[lunarDay];
    }

    public static int getDayOfMonth(int month, boolean isLeapYear) {
        return Month.of(month).length(isLeapYear);
    }

    public static int getDayOfMonth(Date date) {
        return Converter.toLocalDateTime(date).getDayOfMonth();
    }

    public static int getDayOfMonth(Instant instant) {
        return Converter.toLocalDateTime(instant).getDayOfMonth();
    }

    public static int getDayOfMonth(LocalDateTime localDateTime) {
        return localDateTime.getDayOfMonth();
    }

    public static int getDayOfMonth(LocalDate localDate) {
        return localDate.getDayOfMonth();
    }

    public static int getDayOfYear(Date date) {
        return Converter.toLocalDateTime(date).getDayOfYear();
    }

    public static int getDayOfYear(Instant instant) {
        return Converter.toLocalDateTime(instant).getDayOfYear();
    }

    public static int getDayOfYear(LocalDateTime localDateTime) {
        return localDateTime.getDayOfYear();
    }

    public static int getDayOfYear(LocalDate localDate) {
        return localDate.getDayOfYear();
    }

    public static int getLengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int getDayOfYear() {
        return Almanac.getDayOfYear(new Date());
    }

    public static int getHour(Date date) {
        return Converter.toLocalDateTime(date).getHour();
    }

    public static int getHour(Instant instant) {
        return Converter.toLocalDateTime(instant).getHour();
    }

    public static int getHour(LocalDateTime localDateTime) {
        return localDateTime.getHour();
    }

    public static int getHour(LocalTime localTime) {
        return localTime.getHour();
    }

    public static int getMinute(Date date) {
        return Converter.toLocalDateTime(date).getMinute();
    }

    public static int getMinute(Instant instant) {
        return Converter.toLocalDateTime(instant).getMinute();
    }

    public static int getMinute(LocalDateTime localDateTime) {
        return localDateTime.getMinute();
    }

    public static int getMinute(LocalTime localTime) {
        return localTime.getMinute();
    }

    public static int getSecond(Date date) {
        return Converter.toLocalDateTime(date).getSecond();
    }

    public static int getSecond(Instant instant) {
        return Converter.toLocalDateTime(instant).getSecond();
    }

    public static int getSecond(LocalDateTime localDateTime) {
        return localDateTime.getSecond();
    }

    public static int getSecond(LocalTime localTime) {
        return localTime.getSecond();
    }

    public static int getMillisecond(Date date) {
        return Converter.toLocalDateTime(date).getNano() / 1000000;
    }

    public static int getMillisecond(Instant instant) {
        return Converter.toLocalDateTime(instant).getNano() / 1000000;
    }

    public static int getMillisecond(LocalDateTime localDateTime) {
        return localDateTime.getNano() / 1000000;
    }

    public static int getMillisecond(LocalTime localTime) {
        return localTime.getNano() / 1000000;
    }

    public static int getMillisecond(ZonedDateTime zonedDateTime) {
        return zonedDateTime.getNano() / 1000000;
    }

    public static long getEpochMilli() {
        return System.currentTimeMillis();
    }

    public static long getEpochSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getEpochMilliFormat() {
        return Formatter.format(new Date());
    }

    public static String getEpochMilliFormatFull() {
        return Formatter.format(new Date(), "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String getEpochMilliIsoNotFormatNoColon() {
        return Formatter.format(new Date(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public static String getEpochMilliIsoFormatFullNoColon() {
        return Formatter.format(new Date(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public static Date getDate(int year, int month, int dayOfMonth) {
        return Converter.toDate(LocalDate.of(year, month, dayOfMonth));
    }

    public static Date getDate(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return Converter.toDate(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static Date getDate(int year, int month, int dayOfMonth, int hour, int minute, int second, int milliOfSecond) {
        return Converter.toDate(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, milliOfSecond * 1000000));
    }

    public static Date getDateStartOfMonth(int year, int month) {
        return Converter.toDateStartOfMonth(YearMonth.of(year, month));
    }

    public static Date getDateEndOfMonth(int year, int month) {
        return Converter.toDateEndOfMonth(YearMonth.of(year, month));
    }

    public static int getAge(LocalDate birthDay) {
        Period period = Almanac.periodBetween(birthDay, LocalDate.now());
        if (period.getYears() < 0) {
            throw new DateTimeException("birthDay is after now!");
        }
        return period.getYears();
    }

    public static int getAge(Date birthDay) {
        return Almanac.getAge(Converter.toLocalDate(birthDay));
    }

    public static int getAge(LocalDateTime birthDay) {
        return Almanac.getAge(Converter.toLocalDate(birthDay));
    }

    public static int getAge(String birthday) {
        return Almanac.getAge(Long.parseLong(birthday), Calendar.getInstance().getTimeInMillis());
    }

    public static int getAge(Date birthday, Date dateToCompare) {
        if (null == dateToCompare) {
            dateToCompare = Almanac.date();
        }
        return Almanac.getAge(birthday.getTime(), dateToCompare.getTime());
    }

    public static int getAge(Calendar birthday, Calendar dateToCompare) {
        return Almanac.getAge(birthday.getTimeInMillis(), dateToCompare.getTimeInMillis());
    }

    public static int getAge(long birthDay, long dateToCompare) {
        if (birthDay > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        boolean isLastDayOfMonth = dayOfMonth == cal.getActualMaximum(5);
        cal.setTimeInMillis(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            boolean isLastDayOfMonthBirth;
            int dayOfMonthBirth = cal.get(5);
            boolean bl = isLastDayOfMonthBirth = dayOfMonthBirth == cal.getActualMaximum(5);
            if (!(isLastDayOfMonth && isLastDayOfMonthBirth || dayOfMonth >= dayOfMonthBirth)) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static String getAge(String birthDay, String dateToCompare) {
        String[] data;
        if (null == birthDay || birthDay.trim().length() == 0) {
            throw new IllegalArgumentException("birthDay must not be null !");
        }
        if (null == dateToCompare || dateToCompare.trim().length() == 0) {
            dateToCompare = Fields.NORM_DATE_FORMAT.format(new Date());
        }
        if ((data = StringKit.splitToArray((CharSequence)birthDay, "-")).length < 3) {
            throw new IllegalArgumentException("Please confirm the date format !");
        }
        GregorianCalendar birthday = new GregorianCalendar(Integer.valueOf(data[0]), Integer.valueOf(data[1]), Integer.valueOf(data[2]));
        Calendar now = Calendar.getInstance();
        now.setTime(Converter.parse(dateToCompare));
        int day = now.get(5) - birthday.get(5);
        int month = now.get(2) + 1 - birthday.get(2);
        int year = now.get(1) - birthday.get(1);
        if (day < 0) {
            --month;
            now.add(2, -1);
            day += now.getActualMaximum(5);
        }
        if (month < 0) {
            month = (month + 12) % 12;
            --year;
        }
        return (String)(year > 0 ? year + "\u5c81" : "") + (String)(month > 0 ? month + "\u4e2a\u6708" : "") + (String)(day > 0 ? day + "\u5929" : "\u4eca\u65e5\u51fa\u751f");
    }

    public static int getQuarter(LocalDateTime localDateTime) {
        return (localDateTime.getMonthValue() + 2) / 3;
    }

    public static int getQuarter(LocalDate localDate) {
        return (localDate.getMonthValue() + 2) / 3;
    }

    public static int getQuarter(Date date) {
        return (Almanac.getMonth(date) + 2) / 3;
    }

    public static int getQuarter() {
        return (LocalDate.now().getMonthValue() + 2) / 3;
    }

    public static Map<String, String> getLast(int type, String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Date dBegin = Fields.PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = Fields.PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(dBegin);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            if (type == 1) {
                long beginTime = dBegin.getTime();
                long endTime = dEnd.getTime();
                long inter = endTime - beginTime;
                if (inter < 0L) {
                    inter *= -1L;
                }
                long dateMillSec = 86400000L;
                long dateCnt = inter / dateMillSec;
                long remainder = inter % dateMillSec;
                if (remainder != 0L) {
                    ++dateCnt;
                }
                int day = Integer.parseInt(String.valueOf(dateCnt)) + 1;
                calBegin.add(5, -day);
                calEnd.add(5, -day);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
            }
            map.put(beginkey, Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            map.put(endkey, Fields.PURE_DATETIME_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return map;
    }

    public static List<String> getLast(String begin, String end) {
        ArrayList<String> lDate = new ArrayList<String>();
        try {
            Date date1 = Fields.PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = Fields.PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            lDate.add(Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            while (calBegin.compareTo(calEnd) < 0) {
                calBegin.add(5, 1);
                lDate.add(Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            }
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return lDate;
    }

    public static Map<String, String> getLast(int type, String beginkey, String endkey, String beginWkey, String endWkey, String begin, String end, String beginW, String endW) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Date date1 = Fields.PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = Fields.PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calBegin.setFirstDayOfWeek(2);
            calEnd.setFirstDayOfWeek(2);
            if (type == 1) {
                int week = Almanac.getInterval(date1, dEnd);
                calBegin.add(3, -week);
                calEnd.add(3, -week);
                map.put(beginWkey, String.valueOf(calBegin.get(3)));
                map.put(endWkey, String.valueOf(calEnd.get(3)));
                int day_of_week = calBegin.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calBegin.add(5, -day_of_week + 1);
                int day_of_week_end = calEnd.get(7) - 1;
                if (day_of_week_end == 0) {
                    day_of_week_end = 7;
                }
                calEnd.add(5, -day_of_week_end + 7);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
                calBegin.set(3, Integer.parseInt(beginW));
                calEnd.set(3, Integer.parseInt(endW));
                map.put(beginWkey, beginW);
                map.put(endWkey, endW);
                int day_of_week = calBegin.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calBegin.add(5, -day_of_week + 1);
                int day_of_week_end = calEnd.get(7) - 1;
                if (day_of_week_end == 0) {
                    day_of_week_end = 7;
                }
                calEnd.add(5, -day_of_week_end + 7);
            }
            map.put(beginkey, Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            map.put(endkey, Fields.PURE_DATETIME_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return map;
    }

    public static Map<String, String> getLast(String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(Fields.NORM_YEAR_FORMAT.parse(begin));
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(Fields.NORM_YEAR_FORMAT.parse(end));
            int year = calBegin.get(1);
            int year1 = calEnd.get(1);
            int result = year1 - year + 1;
            calBegin.add(1, -result);
            calEnd.add(1, -result);
            map.put(beginkey, Fields.NORM_YEAR_FORMAT.format(calBegin.getTime()));
            map.put(endkey, Fields.NORM_YEAR_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
        return map;
    }

    public static int getInterval(Date start, Date end) {
        Calendar c_begin = Calendar.getInstance();
        c_begin.setTime(start);
        Calendar c_end = Calendar.getInstance();
        c_end.setTime(end);
        int count = 0;
        c_begin.setFirstDayOfWeek(1);
        c_end.setFirstDayOfWeek(1);
        while (c_begin.before(c_end)) {
            if (c_begin.get(7) == 7) {
                ++count;
            }
            c_begin.add(6, 1);
        }
        return count;
    }

    public static int getWeeks(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (7 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static Date withYear(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.YEAR, newValue);
    }

    public static LocalDateTime withYear(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withYear((int)newValue);
    }

    public static LocalDate withYear(LocalDate localDate, long newValue) {
        return localDate.withYear((int)newValue);
    }

    public static Date withYear(Date date, int newValue) {
        return Almanac.with(date, 1, newValue);
    }

    public static LocalDateTime withMonth(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withMonth((int)newValue);
    }

    public static LocalDate withMonth(LocalDate localDate, long newValue) {
        return localDate.withMonth((int)newValue);
    }

    public static Date withMonth(Date date, int newValue) {
        return Almanac.with(date, 2, newValue);
    }

    public static Date withWeek(Date date, int newValue) {
        return Almanac.with(date, 3, newValue);
    }

    public static Date withDay(Date date, int newValue) {
        return Almanac.with(date, 5, newValue);
    }

    public static Date withHour(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.HOUR_OF_DAY, newValue);
    }

    public static LocalDateTime withHour(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withHour((int)newValue);
    }

    public static LocalTime withHour(LocalTime localTime, long newValue) {
        return localTime.withHour((int)newValue);
    }

    public static Date withHour(Date date, int newValue) {
        return Almanac.with(date, 11, newValue);
    }

    public static Date withMinute(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.MINUTE_OF_HOUR, newValue);
    }

    public static LocalDateTime withMinute(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withMinute((int)newValue);
    }

    public static LocalTime withMinute(LocalTime localTime, long newValue) {
        return localTime.withMinute((int)newValue);
    }

    public static Date withMinute(Date date, int newValue) {
        return Almanac.with(date, 12, newValue);
    }

    public static Date withSecond(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.SECOND_OF_MINUTE, newValue);
    }

    public static LocalDateTime withSecond(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withSecond((int)newValue);
    }

    public static LocalTime withSecond(LocalTime localTime, long newValue) {
        return localTime.withSecond((int)newValue);
    }

    public static Date withSecond(Date date, int newValue) {
        return Almanac.with(date, 13, newValue);
    }

    public static Date withMilli(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.MILLI_OF_SECOND, newValue);
    }

    public static LocalDateTime withMilli(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)Almanac.with(localDateTime, (TemporalField)ChronoField.MILLI_OF_SECOND, newValue);
    }

    public static LocalTime withMilli(LocalTime localTime, long newValue) {
        return (LocalTime)Almanac.with(localTime, (TemporalField)ChronoField.MILLI_OF_SECOND, newValue);
    }

    public static Date withMilli(Date date, int newValue) {
        return Almanac.with(date, 14, newValue);
    }

    public static Date withDayOfMonth(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.DAY_OF_MONTH, newValue);
    }

    public static LocalDateTime withDayOfMonth(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withDayOfMonth((int)newValue);
    }

    public static LocalDate withDayOfMonth(LocalDate localDate, long newValue) {
        return localDate.withDayOfMonth((int)newValue);
    }

    public static Date withDayOfYear(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.DAY_OF_YEAR, newValue);
    }

    public static LocalDateTime withDayOfYear(LocalDateTime localDateTime, long newValue) {
        return localDateTime.withDayOfYear((int)newValue);
    }

    public static LocalDate withDayOfYear(LocalDate localDate, long newValue) {
        return localDate.withDayOfYear((int)newValue);
    }

    public static Date withDayOfWeek(Date date, long newValue) {
        return Almanac.with(date, (TemporalField)ChronoField.DAY_OF_WEEK, newValue);
    }

    public static LocalDateTime withDayOfWeek(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)Almanac.with(localDateTime, (TemporalField)ChronoField.DAY_OF_WEEK, newValue);
    }

    public static LocalDate withDayOfWeek(LocalDate localDate, long newValue) {
        return (LocalDate)Almanac.with(localDate, (TemporalField)ChronoField.DAY_OF_WEEK, newValue);
    }

    public static long betweenYears(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Period.between(Converter.toLocalDate(startInclusive), Converter.toLocalDate(endExclusive)).getYears();
    }

    public static long betweenYears(Date startInclusive, Date endExclusive) {
        return Period.between(Converter.toLocalDate(startInclusive), Converter.toLocalDate(endExclusive)).getYears();
    }

    public static long betweenYears(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getYears();
    }

    public static long betweenMonths(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Period.between(Converter.toLocalDate(startInclusive), Converter.toLocalDate(endExclusive)).getMonths();
    }

    public static long betweenMonths(Date startInclusive, Date endExclusive) {
        return Period.between(Converter.toLocalDate(startInclusive), Converter.toLocalDate(endExclusive)).getMonths();
    }

    public static long betweenMonths(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getMonths();
    }

    public static long betweenDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Period.between(Converter.toLocalDate(startInclusive), Converter.toLocalDate(endExclusive)).getDays();
    }

    public static long betweenDays(Date startInclusive, Date endExclusive) {
        return Period.between(Converter.toLocalDate(startInclusive), Converter.toLocalDate(endExclusive)).getDays();
    }

    public static long betweenDays(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getDays();
    }

    public static long betweenTotalDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toDays();
    }

    public static long betweenTotalDays(Date startInclusive, Date endExclusive) {
        return Almanac.durationBetween(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endExclusive)).toDays();
    }

    public static long betweenTotalHours(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long betweenTotalHours(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long betweenTotalHours(Date startInclusive, Date endExclusive) {
        return Almanac.durationBetween(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endExclusive)).toHours();
    }

    public static long betweenTotalMinutes(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long betweenTotalMinutes(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long betweenTotalMinutes(Date startInclusive, Date endExclusive) {
        return Almanac.durationBetween(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endExclusive)).toMinutes();
    }

    public static long betweenTotalSeconds(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).getSeconds();
    }

    public static long betweenTotalSeconds(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).getSeconds();
    }

    public static long betweenTotalSeconds(Date startInclusive, Date endExclusive) {
        return Almanac.durationBetween(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endExclusive)).getSeconds();
    }

    public static long betweenTotalMillis(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static long betweenTotalMillis(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static long betweenTotalMillis(Date startInclusive, Date endExclusive) {
        return Almanac.durationBetween(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endExclusive)).toMillis();
    }

    public static long betweenTotalNanos(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toNanos();
    }

    public static long betweenTotalNanos(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toNanos();
    }

    public static long betweenTotalNanos(Date startInclusive, Date endExclusive) {
        return Almanac.durationBetween(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endExclusive)).toNanos();
    }

    public static int getDayOfWeek(Date date) {
        return Converter.toLocalDateTime(date).getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(LocalDateTime localDateTime) {
        return localDateTime.getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(LocalDate localDate) {
        return localDate.getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(Instant instant) {
        return Converter.toLocalDateTime(instant).getDayOfWeek().getValue();
    }

    public static String getDayOfWeekEnLong(Date date) {
        return Fields.Week.getEnNameByCode(Almanac.getDayOfWeek(date));
    }

    public static String getDayOfWeekEnLong(LocalDateTime localDateTime) {
        return Fields.Week.getEnNameByCode(Almanac.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekEnLong(LocalDate localDate) {
        return Fields.Week.getEnNameByCode(Almanac.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekEnLong(Instant instant) {
        return Fields.Week.getEnNameByCode(Almanac.getDayOfWeek(instant));
    }

    public static String getDayOfWeekEnShort(Date date) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(date));
    }

    public static String getDayOfWeekEnShort(LocalDateTime localDateTime) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekEnShort(LocalDate localDate) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekEnShort(Instant instant) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(instant));
    }

    public static String getDayOfWeekEnShortUpper(Date date) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(date)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(LocalDateTime localDateTime) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(localDateTime)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(LocalDate localDate) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(localDate)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(Instant instant) {
        return Fields.Week.getShortNameByCode(Almanac.getDayOfWeek(instant)).toUpperCase();
    }

    public static String getDayOfWeekCn(Date date) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(date));
    }

    public static String getDayOfWeekCn(LocalDateTime localDateTime) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekCn(LocalDate localDate) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekCn(Instant instant) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(instant));
    }

    public static String getDayOfWeekCnShort(Date date) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(date)).substring(2);
    }

    public static String getDayOfWeekCnShort(LocalDateTime localDateTime) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(localDateTime)).substring(2);
    }

    public static String getDayOfWeekCnShort(LocalDate localDate) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(localDate)).substring(2);
    }

    public static String getDayOfWeekCnShort(Instant instant) {
        return Fields.Week.getCnNameByCode(Almanac.getDayOfWeek(instant)).substring(2);
    }

    public static LocalDate firstDayOfMonth(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime firstDayOfMonth(LocalDateTime localDateTime) {
        return localDateTime.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static Date firstDayOfMonth(Date date) {
        return Converter.toDate(Converter.toLocalDateTime(date).with(TemporalAdjusters.firstDayOfMonth()));
    }

    public static LocalDate lastDayOfMonth(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime lastDayOfMonth(LocalDateTime localDateTime) {
        return localDateTime.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static Date lastDayOfMonth(Date date) {
        return Converter.toDate(Converter.toLocalDateTime(date).with(TemporalAdjusters.lastDayOfMonth()));
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(Almanac.beginOfSecond(Almanac.toCalendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(Almanac.endOfSecond(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return Almanac.truncate(calendar, Fields.Type.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return Almanac.ceiling(calendar, Fields.Type.SECOND);
    }

    public static Calendar beginOfMinute(Calendar calendar) {
        return Almanac.truncate(calendar, Fields.Type.MINUTE);
    }

    public static Calendar endOfMinute(Calendar calendar) {
        return Almanac.ceiling(calendar, Fields.Type.MINUTE);
    }

    public static DateTime beginOfMinute(Date date) {
        return new DateTime(Almanac.beginOfMinute(Almanac.toCalendar(date)));
    }

    public static DateTime endOfMinute(Date date) {
        return new DateTime(Almanac.endOfMinute(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfHour(Calendar calendar) {
        return Almanac.truncate(calendar, Fields.Type.HOUR_OF_DAY);
    }

    public static Calendar endOfHour(Calendar calendar) {
        return Almanac.ceiling(calendar, Fields.Type.HOUR_OF_DAY);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(Almanac.beginOfDay(Almanac.toCalendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(Almanac.endOfDay(Almanac.toCalendar(date)));
    }

    public static DateTime beginOfHour(Date date) {
        return new DateTime(Almanac.beginOfHour(Almanac.toCalendar(date)));
    }

    public static DateTime endOfHour(Date date) {
        return new DateTime(Almanac.endOfHour(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return Almanac.truncate(calendar, Fields.Type.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return Almanac.ceiling(calendar, Fields.Type.DAY_OF_MONTH);
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(Almanac.beginOfWeek(Almanac.toCalendar(date)));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(Almanac.endOfWeek(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return Almanac.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        calendar.setFirstDayOfWeek(isMondayAsFirstDay ? 2 : 1);
        return Almanac.truncate(calendar, Fields.Type.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return Almanac.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        calendar.setFirstDayOfWeek(isSundayAsLastDay ? 2 : 1);
        return Almanac.ceiling(calendar, Fields.Type.WEEK_OF_MONTH);
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(Almanac.beginOfMonth(Almanac.toCalendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(Almanac.endOfMonth(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return Almanac.truncate(calendar, Fields.Type.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return Almanac.ceiling(calendar, Fields.Type.MONTH);
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(Almanac.beginOfQuarter(Almanac.toCalendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(Almanac.endOfQuarter(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.Type.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return Almanac.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.Type.MONTH.getValue()) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return Almanac.endOfDay(calendar);
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(Almanac.beginOfYear(Almanac.toCalendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(Almanac.endOfYear(Almanac.toCalendar(date)));
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return Almanac.truncate(calendar, Fields.Type.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return Almanac.ceiling(calendar, Fields.Type.YEAR);
    }

    public static boolean isLeapYear(LocalDate localDate) {
        return localDate.isLeapYear();
    }

    public static boolean isLeapYear(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate().isLeapYear();
    }

    public static boolean isLeapYear(Date date) {
        return Converter.toLocalDateTime(date).toLocalDate().isLeapYear();
    }

    public static boolean isLeapYear(int year) {
        return Solar.isLeapYear(year);
    }

    public static int nextLeapYear(int year) {
        for (int i = 0; i < 8; ++i) {
            if (!Almanac.isLeapYear(++year)) continue;
            return year;
        }
        return -1;
    }

    public static LocalDateTime nextLeapYear(LocalDateTime localDateTime) {
        return localDateTime.withYear(Almanac.nextLeapYear(localDateTime.getYear()));
    }

    public static LocalDate nextLeapYear(LocalDate localDate) {
        return localDate.withYear(Almanac.nextLeapYear(localDate.getYear()));
    }

    public static Date nextLeapYear(Date date) {
        return Converter.toDate(Almanac.nextLeapYear(Converter.toLocalDateTime(date)));
    }

    public static boolean isWorkDay(Date date) {
        int dayOfWeek = Almanac.getDayOfWeek(date);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWorkDay(LocalDateTime localDateTime) {
        int dayOfWeek = Almanac.getDayOfWeek(localDateTime);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWorkDay(LocalDate localDate) {
        int dayOfWeek = Almanac.getDayOfWeek(localDate);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWeekend(Date date) {
        return !Almanac.isWorkDay(date);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return !Almanac.isWorkDay(localDateTime);
    }

    public static boolean isWeekend(LocalDate localDate) {
        return !Almanac.isWorkDay(localDate);
    }

    public static int lengthOfMonth(LocalDate localDate) {
        return localDate.lengthOfMonth();
    }

    public static int lengthOfMonth(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate().lengthOfMonth();
    }

    public static int lengthOfMonth(Date date) {
        return Converter.toLocalDateTime(date).toLocalDate().lengthOfMonth();
    }

    public static int lengthOfYear(LocalDate localDate) {
        return localDate.lengthOfYear();
    }

    public static int lengthOfYear(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate().lengthOfYear();
    }

    public static int lengthOfYear(Date date) {
        return Converter.toLocalDateTime(date).toLocalDate().lengthOfYear();
    }

    public static LocalDate next(LocalDate localDate, DayOfWeek dayOfWeek) {
        return localDate.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static LocalDateTime next(LocalDateTime localDateTime, DayOfWeek dayOfWeek) {
        return localDateTime.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static Date next(Date date, DayOfWeek dayOfWeek) {
        return Converter.toDate(Converter.toLocalDateTime(date).with(TemporalAdjusters.next(dayOfWeek)));
    }

    public static LocalDate previous(LocalDate localDate, DayOfWeek dayOfWeek) {
        return localDate.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static LocalDateTime previous(LocalDateTime localDateTime, DayOfWeek dayOfWeek) {
        return localDateTime.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static Date previous(Date date, DayOfWeek dayOfWeek) {
        return Converter.toDate(Converter.toLocalDateTime(date).with(TemporalAdjusters.previous(dayOfWeek)));
    }

    public static LocalDate nextWorkDay(LocalDate localDate) {
        return localDate.with(Almanac.nextWorkDay());
    }

    public static LocalDateTime nextWorkDay(LocalDateTime localDateTime) {
        return localDateTime.with(Almanac.nextWorkDay());
    }

    public static Date nextWorkDay(Date date) {
        return Converter.toDate(Converter.toLocalDateTime(date).with(Almanac.nextWorkDay()));
    }

    public static TemporalAdjuster nextWorkDay() {
        return temporal -> {
            DayOfWeek dayOfWeek = DayOfWeek.of(temporal.get(ChronoField.DAY_OF_WEEK));
            int add = 1;
            if (dayOfWeek == DayOfWeek.FRIDAY) {
                add = 3;
            }
            if (dayOfWeek == DayOfWeek.SATURDAY) {
                add = 2;
            }
            return temporal.plus(add, ChronoUnit.DAYS);
        };
    }

    public static ZonedDateTime getZonedDateTimeNowOfDefault() {
        return ZonedDateTime.now(java.time.ZoneId.systemDefault());
    }

    public static ZonedDateTime getZonedDateTimeNowOfCTT() {
        return ZonedDateTime.now(java.time.ZoneId.of(ZoneId.CTT.getEnName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfECT() {
        return ZonedDateTime.now(java.time.ZoneId.of(ZoneId.ECT.getEnName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfEST() {
        return ZonedDateTime.now(java.time.ZoneId.of(ZoneId.EST.getEnName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfJST() {
        return ZonedDateTime.now(java.time.ZoneId.of(ZoneId.JST.getEnName()));
    }

    public static Temporal with(Temporal temporal, TemporalField field, long newValue) {
        return temporal.with(field, newValue);
    }

    public static Date with(Date date, TemporalField field, long newValue) {
        return Converter.toDate(Converter.toLocalDateTime(date).with(field, newValue));
    }

    private static Date with(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Duration durationBetween(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return Period.between(startDateInclusive, endDateExclusive);
    }

    public static ZonedDateTime getZonedDateTimeNow(String zoneId) {
        return ZonedDateTime.now(java.time.ZoneId.of(zoneId));
    }

    public static ZonedDateTime transform(ZonedDateTime zonedDateTime, String zoneId) {
        return Almanac.transform(zonedDateTime, java.time.ZoneId.of(zoneId));
    }

    public static ZonedDateTime transform(ZonedDateTime zonedDateTime, java.time.ZoneId zone) {
        return zonedDateTime.withZoneSameInstant(zone);
    }

    public static String transform(Date date, String zoneId) {
        return Almanac.transform(date, java.time.ZoneId.of(zoneId));
    }

    public static String transform(Date date, java.time.ZoneId zone) {
        return Formatter.format(date, zone.toString());
    }

    public static int compare(Date date1, Date date2) {
        return Almanac.compare(Converter.toLocalDateTime(date1), Converter.toLocalDateTime(date2));
    }

    public static int compare(Temporal temporal1, Temporal temporal2) {
        if (temporal1 instanceof LocalDateTime && temporal2 instanceof LocalDateTime) {
            LocalDateTime localDateTimeA = (LocalDateTime)temporal1;
            LocalDateTime localDateTimeB = (LocalDateTime)temporal2;
            return localDateTimeA.compareTo(localDateTimeB);
        }
        if (temporal1 instanceof LocalDate && temporal2 instanceof LocalDate) {
            LocalDate localDateA = (LocalDate)temporal1;
            LocalDate localDateB = (LocalDate)temporal2;
            return localDateA.compareTo(localDateB);
        }
        if (temporal1 instanceof LocalTime && temporal2 instanceof LocalTime) {
            LocalTime localTimeA = (LocalTime)temporal1;
            LocalTime localTimeB = (LocalTime)temporal2;
            return localTimeA.compareTo(localTimeB);
        }
        if (temporal1 instanceof Instant && temporal2 instanceof Instant) {
            Instant instantA = (Instant)temporal1;
            Instant instantB = (Instant)temporal2;
            return instantA.compareTo(instantB);
        }
        throw new DateTimeException("Unsupported Temporal, must be LocalDateTime,LocalDate,LocalTime,Instant");
    }

    public static int compare(Date date) {
        return date.compareTo(new Date());
    }

    public static int compare(long date) {
        long now = Almanac.timestamp();
        return Long.compare(date, now);
    }

    public static boolean compare(String object) {
        long expired = Almanac.timestamp() - Long.parseLong(object) * 1000L;
        return expired <= 900000L && expired >= -900000L;
    }

    public static LocalTime startTimeOfDay() {
        return LocalTime.MIN;
    }

    public static LocalTime endTimeOfDay() {
        return LocalTime.of(23, 59, 59);
    }

    public static LocalTime endAccuracyTimeOfDay() {
        return LocalTime.MAX;
    }

    public static Date startTimeOfYesterday() {
        return Converter.toDate(LocalDate.now().minusDays(1L).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfYesterday() {
        return Converter.toDate(LocalDate.now().minusDays(1L).atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfTomorrow() {
        return Converter.toDate(LocalDate.now().plusDays(1L).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfTomorrow() {
        return Converter.toDate(LocalDate.now().plusDays(1L).atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfToday() {
        return Converter.toDate(LocalDate.now().atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfToday() {
        return Converter.toDate(LocalDate.now().atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfLastMonth() {
        return Converter.toDate(Almanac.firstDayOfMonth(LocalDate.now().minusMonths(1L)).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfLastMonth() {
        return Converter.toDate(Almanac.lastDayOfMonth(LocalDate.now().minusMonths(1L)).atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfMonth() {
        return Converter.toDate(Almanac.firstDayOfMonth(LocalDate.now()).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfMonth() {
        return Converter.toDate(Almanac.lastDayOfMonth(LocalDate.now()).atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfDate(Date date) {
        return Converter.toDate(Converter.toLocalDate(date).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfDate(Date date) {
        return Converter.toDate(Converter.toLocalDate(date).atTime(Almanac.endTimeOfDay()));
    }

    public static Date endAccuracyTimeOfDate(Date date) {
        return Converter.toDate(Converter.toLocalDate(date).atTime(Almanac.endAccuracyTimeOfDay()));
    }

    public static LocalDateTime startTimeOfLocalDateTime(LocalDateTime localDateTime) {
        return localDateTime.with(Almanac.startTimeOfDay());
    }

    public static LocalDateTime endAccuracyTimeOfLocalDateTime(LocalDateTime localDateTime) {
        return localDateTime.with(Almanac.endAccuracyTimeOfDay());
    }

    public static Date startTimeOfSpecialMonth(int year, int month) {
        return Converter.toDate(LocalDate.of(year, month, 1).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfSpecialMonth(int year, int month) {
        return Converter.toDate(Almanac.lastDayOfMonth(LocalDate.of(year, month, 1)).atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfDate(int year, int month, int dayOfMonth) {
        return Converter.toDate(LocalDate.of(year, month, dayOfMonth).atTime(Almanac.startTimeOfDay()));
    }

    public static Date endTimeOfDate(int year, int month, int dayOfMonth) {
        return Converter.toDate(LocalDate.of(year, month, dayOfMonth).atTime(Almanac.endTimeOfDay()));
    }

    public static Date startTimeOfFirstQuarter(int year) {
        return Almanac.startTimeOfSpecialMonth(year, 1);
    }

    public static Date startTimeOfSecondQuarter(int year) {
        return Almanac.startTimeOfSpecialMonth(year, 4);
    }

    public static Date startTimeOfThirdQuarter(int year) {
        return Almanac.startTimeOfSpecialMonth(year, 7);
    }

    public static Date startTimeOfFourthQuarter(int year) {
        return Almanac.startTimeOfSpecialMonth(year, 10);
    }

    public static Date endTimeOfFirstQuarter(int year) {
        return Almanac.endTimeOfSpecialMonth(year, 3);
    }

    public static Date endTimeOfSecondQuarter(int year) {
        return Almanac.endTimeOfSpecialMonth(year, 6);
    }

    public static Date endTimeOfThirdQuarter(int year) {
        return Almanac.endTimeOfSpecialMonth(year, 9);
    }

    public static Date endTimeOfFourthQuarter(int year) {
        return Almanac.endTimeOfSpecialMonth(year, 12);
    }

    public static Date startTimeOfCurrentQuarter() {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int firstMonthOfQuarter = now.getMonth().firstMonthOfQuarter().getValue();
        return Almanac.startTimeOfSpecialMonth(year, firstMonthOfQuarter);
    }

    public static Date endTimeOfCurrentQuarter() {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int endMonthOfQuarter = now.getMonth().firstMonthOfQuarter().getValue() + 2;
        return Almanac.endTimeOfSpecialMonth(year, endMonthOfQuarter);
    }

    public static Date startTimeOfYear(int year) {
        return Almanac.startTimeOfSpecialMonth(year, 1);
    }

    public static Date endTimeOfYear(int year) {
        return Almanac.endTimeOfSpecialMonth(year, 12);
    }

    public static Date startTimeOfCurrentYear() {
        return Almanac.startTimeOfYear(LocalDate.now().getYear());
    }

    public static Date endTimeOfCurrentYear() {
        return Almanac.endTimeOfYear(LocalDate.now().getYear());
    }

    public static boolean isSameTime(Calendar date1, Calendar date2) {
        if (null == date1) {
            return null == date2;
        }
        if (null == date2) {
            return false;
        }
        return date1.getTimeInMillis() == date2.getTimeInMillis();
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (null == cal1 || null == cal2) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return Almanac.isSameDay(Converter.toCalendar(date1), Converter.toCalendar(date2));
    }

    public static boolean isSameDay(LocalDate date1, LocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }

    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return date1 != null && date2 != null && date1.toLocalDate().isEqual(date2.toLocalDate());
    }

    public static boolean isSameWeek(Calendar cal1, Calendar cal2, boolean isMon) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        cal1 = (Calendar)cal1.clone();
        cal2 = (Calendar)cal2.clone();
        if (isMon) {
            cal1.setFirstDayOfWeek(2);
            cal1.set(7, 2);
            cal2.setFirstDayOfWeek(2);
            cal2.set(7, 2);
        } else {
            cal1.setFirstDayOfWeek(1);
            cal1.set(7, 1);
            cal2.setFirstDayOfWeek(1);
            cal2.set(7, 1);
        }
        return Almanac.isSameDay(cal1, cal2);
    }

    public static boolean isSameWeek(Date date1, Date date2, boolean isMon) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return Almanac.isSameWeek(Converter.toCalendar(date1), Converter.toCalendar(date2), isMon);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return Almanac.isSameMonth(Converter.toCalendar(date1), Converter.toCalendar(date2));
    }

    public static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        if (null == cal1 || null == cal2) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameMonthDay(LocalDate localDate1, MonthDay monthDay) {
        return MonthDay.of(localDate1.getMonthValue(), localDate1.getDayOfMonth()).equals(monthDay);
    }

    public static boolean isSameMonthDay(LocalDate localDate1, String monthDayStr) {
        return Almanac.isSameMonthDay(localDate1, MonthDay.parse("--" + monthDayStr));
    }

    public static boolean isSameMonthDay(LocalDate localDate1, LocalDate localDate2) {
        return Almanac.isSameMonthDay(localDate1, MonthDay.of(localDate2.getMonthValue(), localDate2.getDayOfMonth()));
    }

    public static boolean isSameMonthDay(Date date, String monthDayStr) {
        return Almanac.isSameMonthDay(Converter.toLocalDate(date), monthDayStr);
    }

    public static boolean isSameMonthDay(Date date1, Date date2) {
        return Almanac.isSameMonthDay(Converter.toLocalDate(date1), Converter.toLocalDate(date2));
    }

    public static boolean isSameMonthDayOfNow(String monthDayStr) {
        return Almanac.isSameMonthDay(LocalDate.now(), monthDayStr);
    }

    public static long betweenNextSameMonthDay(LocalDate localDate1, int month, int dayOfMonth) {
        MonthDay monthDay2;
        MonthDay monthDay1 = MonthDay.of(localDate1.getMonthValue(), localDate1.getDayOfMonth());
        if (monthDay1.compareTo(monthDay2 = MonthDay.of(month, dayOfMonth)) == -1) {
            return Almanac.betweenTotalDays(localDate1.atStartOfDay(), localDate1.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
        }
        MonthDay leapMonthDay = MonthDay.of(2, 29);
        if (leapMonthDay.equals(monthDay2)) {
            LocalDate nextLeapYear = Almanac.nextLeapYear(localDate1);
            return Almanac.betweenTotalDays(localDate1.atStartOfDay(), nextLeapYear.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
        }
        LocalDate next = localDate1.plusYears(1L);
        return Almanac.betweenTotalDays(localDate1.atStartOfDay(), next.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
    }

    public static long betweenNextSameMonthDay(LocalDate localDate, String monthDayStr) {
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return Almanac.betweenNextSameMonthDay(localDate, monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static long betweenNextSameMonthDay(Date date, String monthDayStr) {
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return Almanac.betweenNextSameMonthDay(Converter.toLocalDate(date), monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static long betweenNextSameMonthDayOfNow(String monthDayStr) {
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return Almanac.betweenNextSameMonthDay(LocalDate.now(), monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static LocalDate nextSameMonthDay(LocalDate localDate, String monthDayStr) {
        return localDate.plusDays(Almanac.betweenNextSameMonthDay(localDate, monthDayStr));
    }

    public static Date nextSameMonthDay(Date date, String monthDayStr) {
        return Converter.toDate(Almanac.nextSameMonthDay(Converter.toLocalDate(date), monthDayStr));
    }

    public static Date nextSameMonthDayOfNow(String monthDayStr) {
        return Almanac.nextSameMonthDay(new Date(), monthDayStr);
    }

    public static String getZodiacCnName(String monthDay) {
        return Fields.Zodiac.getCnNameByMonthDay(monthDay);
    }

    public static String getZodiacCnName(Date date) {
        return Fields.Zodiac.getCnNameByMonthDay(Formatter.format(date));
    }

    public static String getZodiacEnName(String monthDay) {
        return Fields.Zodiac.getEnNameByMonthDay(monthDay);
    }

    public static String getZodiacEnName(Date date) {
        return Fields.Zodiac.getEnNameByMonthDay(Formatter.format(date));
    }

    public static String getZodiac(Date date) {
        return Almanac.getZodiac(Converter.toCalendar(date));
    }

    public static String getZodiac(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return Almanac.getZodiac(calendar.get(2), calendar.get(5));
    }

    public static String getZodiac(int month, int day) {
        return day < Fields.SLICED[month] ? Fields.ZODIAC[month] : Fields.ZODIAC[month + 1];
    }

    public static List<LocalDateTime> getLocalDateTimeList(LocalDateTime startInclusive, LocalDateTime endInclusive) {
        if (startInclusive.isAfter(endInclusive)) {
            throw new DateTimeException("startInclusive must before or equal endInclusive!");
        }
        ArrayList<LocalDateTime> localDateTimeList = new ArrayList<LocalDateTime>();
        long days = Almanac.betweenTotalDays(startInclusive, endInclusive) + 1L;
        for (long i = 0L; i < days; ++i) {
            localDateTimeList.add(startInclusive.plusDays(i));
        }
        return localDateTimeList;
    }

    public static List<LocalDate> getLocalDateList(LocalDate startInclusive, LocalDate endInclusive) {
        return Almanac.getLocalDateTimeList(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endInclusive)).stream().map(localDateTime -> localDateTime.toLocalDate()).collect(Collectors.toList());
    }

    public static List<LocalDate> getLocalDateList(YearMonth yearMonth) {
        ArrayList<LocalDate> localDateList = new ArrayList<LocalDate>();
        long days = yearMonth.lengthOfMonth();
        LocalDate localDate = Converter.toLocalDateStartOfMonth(yearMonth);
        for (long i = 0L; i < days; ++i) {
            localDateList.add(localDate.plusDays(i));
        }
        return localDateList;
    }

    public static List<LocalDate> getLocalDateList(String yearMonthStr) {
        YearMonth yearMonth = YearMonth.parse(yearMonthStr);
        return Almanac.getLocalDateList(yearMonth);
    }

    public static List<LocalDate> getLocalDateList(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        return Almanac.getLocalDateList(yearMonth);
    }

    public static List<LocalDateTime> getLocalDateTimeList(YearMonth yearMonth) {
        return Almanac.getLocalDateList(yearMonth).stream().map(localDate -> Converter.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<LocalDateTime> getLocalDateTimeList(String yearMonthStr) {
        return Almanac.getLocalDateList(yearMonthStr).stream().map(localDate -> Converter.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<LocalDateTime> getLocalDateTimeList(int year, int month) {
        return Almanac.getLocalDateList(YearMonth.of(year, month)).stream().map(localDate -> Converter.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(String yearMonthStr) {
        return Almanac.getLocalDateList(yearMonthStr).stream().map(localDate -> Converter.toDate(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(int year, int month) {
        return Almanac.getLocalDateList(YearMonth.of(year, month)).stream().map(localDate -> Converter.toDate(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(Date startInclusive, Date endInclusive) {
        return Almanac.getLocalDateTimeList(Converter.toLocalDateTime(startInclusive), Converter.toLocalDateTime(endInclusive)).stream().map(localDateTime -> Converter.toDate(localDateTime)).collect(Collectors.toList());
    }

    public static boolean isExpiry(YearMonth yearMonth) {
        return yearMonth.isBefore(YearMonth.now());
    }

    public static boolean isExpiry(String value) {
        YearMonth yearMonth = YearMonth.parse(value);
        return Almanac.isExpiry(yearMonth);
    }

    public static boolean isBirthday(CharSequence value) {
        Matcher matcher = RegEx.BIRTHDAY.matcher(value);
        if (matcher.find()) {
            return DateKit.isBirthday(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(5)));
        }
        return false;
    }

    public static boolean isBirthDay(Date date) {
        return Almanac.isBirthDay(Converter.toLocalDate(date));
    }

    public static boolean isBirthDay(LocalDate localDate) {
        return Almanac.isSameMonthDay(localDate, LocalDate.now());
    }

    public static boolean isBirthDay(LocalDateTime localDateTime) {
        return Almanac.isBirthDay(Converter.toLocalDate(localDateTime));
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateKit.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && DateKit.isLeapYear(year);
        }
        return true;
    }

    public static LocalDateTime reduceAccuracyToSecond(LocalDateTime localDateTime) {
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }

    public static Date reduceAccuracyToSecond(Date date) {
        return Converter.toDate(Almanac.reduceAccuracyToSecond(Converter.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToMinute(LocalDateTime localDateTime) {
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), 0);
    }

    public static Date reduceAccuracyToMinute(Date date) {
        return Converter.toDate(Almanac.reduceAccuracyToMinute(Converter.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToHour(LocalDateTime localDateTime) {
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), 0, 0);
    }

    public static Date reduceAccuracyToHour(Date date) {
        return Converter.toDate(Almanac.reduceAccuracyToHour(Converter.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToDay(LocalDateTime localDateTime) {
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), 0, 0, 0);
    }

    public static Date reduceAccuracyToDay(Date date) {
        return Converter.toDate(Almanac.reduceAccuracyToDay(Converter.toLocalDateTime(date)));
    }

    public static int weekOfMonth(LocalDate localDate, Locale locale) {
        WeekFields weekFields = null == locale ? WeekFields.of(Locale.getDefault()) : WeekFields.of(locale);
        return (int)weekFields.weekOfMonth().getFrom(localDate);
    }

    public static int weekOfMonth(LocalDate localDate) {
        return Almanac.weekOfMonth(localDate, null);
    }

    public static int weekOfMonth(LocalDateTime localDateTime) {
        return Almanac.weekOfMonth(Converter.toLocalDate(localDateTime), null);
    }

    public static int weekOfMonth(Date date) {
        return Almanac.weekOfMonth(Converter.toLocalDate(date), null);
    }

    public static int weekOfMonth() {
        return Almanac.weekOfMonth(LocalDate.now());
    }

    public static int weekOfYear(LocalDate localDate, Locale locale) {
        WeekFields weekFields = null == locale ? WeekFields.of(Locale.getDefault()) : WeekFields.of(locale);
        return (int)weekFields.weekOfYear().getFrom(localDate);
    }

    public static int weekOfYear(LocalDate localDate) {
        return Almanac.weekOfYear(localDate, null);
    }

    public static int weekOfYear(LocalDateTime localDateTime) {
        return Almanac.weekOfYear(Converter.toLocalDate(localDateTime), null);
    }

    public static int weekOfYear(Date date) {
        return Almanac.weekOfYear(Converter.toLocalDate(date), null);
    }

    public static int weekOfYear() {
        return Almanac.weekOfYear(LocalDate.now());
    }

    public static boolean isMonday(LocalDate localDate) {
        return Fields.Week.Mon.getKey() == localDate.getDayOfWeek().getValue();
    }

    public static boolean isMonday(Date date) {
        return Almanac.isMonday(Converter.toLocalDate(date));
    }

    public static boolean isFriday(LocalDate localDate) {
        return Fields.Week.Fri.getKey() == localDate.getDayOfWeek().getValue();
    }

    public static boolean isFriday(Date date) {
        return Almanac.isFriday(Converter.toLocalDate(date));
    }

    public static boolean isDate(String dptDate, String pattern) {
        if (null == dptDate || dptDate.isEmpty()) {
            return false;
        }
        String formatDate = Formatter.format(dptDate, pattern, pattern);
        return formatDate.equals(dptDate);
    }

    public static boolean isDate(String dptDate) {
        return Almanac.isDate(dptDate, "yyyy-MM-dd");
    }

    public static boolean isBefore(String go, String back, String pattern) {
        if (null == go || null == back || go.isEmpty() || back.isEmpty()) {
            return false;
        }
        DateTime goDate = Almanac.offsetDay(Formatter.parse(go, pattern), -1);
        DateTime backDate = Formatter.parse(back, pattern);
        if (null != goDate && null != backDate) {
            return goDate.before(backDate);
        }
        return false;
    }

    public static boolean isBefore(String go, String back) {
        return Almanac.isBefore(go, back, "yyyy-MM-dd");
    }

    public static boolean isDatetime(String datetime) {
        return Almanac.isDate(datetime, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isShortDate(String date) {
        if (null == date || "".equals(date)) {
            return false;
        }
        String regex = "^([\\d]{4}(((0[13578]|1[02])((0[1-9])|([12][0-9])|(3[01])))|(((0[469])|11)((0[1-9])|([12][1-9])|30))|(02((0[1-9])|(1[0-9])|(2[1-8])))))|((((([02468][048])|([13579][26]))00)|([0-9]{2}(([02468][048])|([13579][26]))))(((0[13578]|1[02])((0[1-9])|([12][0-9])|(3[01])))|(((0[469])|11)((0[1-9])|([12][1-9])|30))|(02((0[1-9])|(1[0-9])|(2[1-9])))))$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(date);
        return matcher.matches();
    }

    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        return startTime.isBefore(realEndTime) && endTime.isAfter(realStartTime);
    }

    public static boolean isNotLessThanToday(String date) {
        return Almanac.isNotLessThanToday(date, "yyyy-MM-dd");
    }

    public static boolean isNotLessThanToday(String date, String format) {
        if (null == date || date.isEmpty()) {
            return false;
        }
        DateTime cmpDate = Almanac.offsetDay(new Date(), -1);
        DateTime srcDate = new DateTime((CharSequence)date, format);
        return srcDate.after(cmpDate);
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static boolean isPM(Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate) {
        long endMills;
        long beginMills;
        long thisMills = Almanac.toEpochMilli(date);
        return thisMills >= Math.min(beginMills = Almanac.toEpochMilli(beginDate), endMills = Almanac.toEpochMilli(endDate)) && thisMills <= Math.max(beginMills, endMills);
    }

    public static String getChrono(LocalTime localTime) {
        return Fields.Chrono.getName(localTime);
    }

    public static String getChrono(LocalDateTime localDateTime) {
        return Fields.Chrono.getName(Converter.toLocalTime(localDateTime));
    }

    public static String getChrono(Date date) {
        return Fields.Chrono.getName(date);
    }

    public static String getChrono() {
        return Fields.Chrono.getName(LocalTime.now());
    }

    public static String getAnimal(Date date) {
        return Almanac.getAnimal(Converter.toCalendar(date));
    }

    public static String getAnimal(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return Almanac.getAnimal(calendar.get(1));
    }

    public static String getAnimal(int year) {
        return Fields.CN_ANIMAL[(year - 4) % 12];
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static DateTime ceiling(Date date, Fields.Type type) {
        return new DateTime(Almanac.ceiling(Almanac.toCalendar(date), type));
    }

    public static Calendar ceiling(Calendar calendar, Fields.Type type) {
        return Almanac.ceiling(calendar, type.getValue(), Fields.Modify.CEILING);
    }

    public static Calendar ceiling(Calendar calendar, int dateField, Fields.Modify modify) {
        return Almanac.ceiling(calendar, dateField, modify, false);
    }

    public static Calendar ceiling(Calendar calendar, int field, Fields.Modify modify, boolean truncateMillisecond) {
        if (9 == field) {
            boolean isAM = Almanac.isAM(calendar);
            switch (modify) {
                case TRUNCATE: {
                    calendar.set(11, isAM ? 0 : 12);
                    break;
                }
                case CEILING: {
                    calendar.set(11, isAM ? 11 : 23);
                    break;
                }
                case ROUND: {
                    int min = isAM ? 0 : 12;
                    int max = isAM ? 11 : 23;
                    int href = (max - min) / 2 + 1;
                    int value = calendar.get(11);
                    calendar.set(11, value < href ? min : max);
                }
            }
            return Almanac.ceiling(calendar, field + 1, modify);
        }
        int[] ignoreFields = new int[]{11, 9, 8, 6, 4, 3};
        int endField = truncateMillisecond ? 13 : 14;
        for (int i = field + 1; i <= endField; ++i) {
            if (ArrayKit.contains(ignoreFields, i) || (4 == field || 3 == field ? 5 == i : 7 == i)) continue;
            Almanac.truncate(calendar, i, modify);
        }
        if (truncateMillisecond) {
            calendar.set(14, 0);
        }
        return calendar;
    }

    public static DateTime truncate(Date date, Fields.Type type) {
        return new DateTime(Almanac.truncate(Almanac.toCalendar(date), type));
    }

    public static Calendar truncate(Calendar calendar, Fields.Type type) {
        return Almanac.ceiling(calendar, type.getValue(), Fields.Modify.TRUNCATE);
    }

    private static void truncate(Calendar calendar, int field, Fields.Modify modify) {
        if (10 == field) {
            field = 11;
        }
        switch (modify) {
            case TRUNCATE: {
                calendar.set(field, Almanac.getBeginValue(calendar, field));
                break;
            }
            case CEILING: {
                calendar.set(field, Almanac.getEndValue(calendar, field));
                break;
            }
            case ROUND: {
                int min = Almanac.getBeginValue(calendar, field);
                int max = Almanac.getEndValue(calendar, field);
                int href = 7 == field ? (min + 3) % 7 : (max - min) / 2 + 1;
                int value = calendar.get(field);
                calendar.set(field, value < href ? min : max);
            }
        }
    }

    public static DateTime round(Date date, Fields.Type type) {
        return new DateTime(Almanac.round(Almanac.toCalendar(date), type));
    }

    public static Calendar round(Calendar calendar, Fields.Type type) {
        return Almanac.ceiling(calendar, type.getValue(), Fields.Modify.ROUND);
    }

    public static long between(Date beginDate, Date endDate, Fields.Units units) {
        return Almanac.between(beginDate, endDate, units, true);
    }

    public static long between(Date beginDate, Date endDate, Fields.Units units, boolean isAbs) {
        return new Between(beginDate, endDate, isAbs).between(units);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new Between(beginDate, endDate).between(Fields.Units.MILLISECOND);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = Almanac.beginOfDay(beginDate);
            endDate = Almanac.beginOfDay(endDate);
        }
        return Almanac.between(beginDate, endDate, Fields.Units.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenYear(isReset);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.MONTH, offset);
    }

    public static DateTime offsetYear(Date date, int offset) {
        return Almanac.offset(date, Fields.Type.YEAR, offset);
    }

    public static DateTime offset(Date date, Fields.Type type, int offset) {
        return new DateTime(date).offset(type, offset);
    }

    public static String now() {
        return Formatter.format(Almanac.date());
    }

    public static String today() {
        return Almanac.formatDate(Almanac.date());
    }

    public static long timestamp() {
        return Almanac.timestamp(false);
    }

    public static long timestamp(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static int thisYear() {
        return Almanac.offsetYear(Almanac.date(), 0).year();
    }

    public static int thisMonth() {
        return Almanac.offsetMonth(Almanac.date(), 0).month();
    }

    public static int thisWeek() {
        return Almanac.offsetWeek(Almanac.date(), 0).dayOfWeek();
    }

    public static Date tomorrow() {
        return Almanac.offsetDay(Almanac.date(), 1);
    }

    public static Date nextWeek() {
        return Almanac.offsetWeek(Almanac.date(), 1);
    }

    public static Date nextMonth() {
        return Almanac.offsetMonth(Almanac.date(), 1);
    }

    public static Date nextYear() {
        return Almanac.offsetYear(Almanac.date(), 1);
    }

    public static Date yesterday() {
        return Almanac.offsetDay(Almanac.date(), -1);
    }

    public static Date lastWeek() {
        return Almanac.offsetWeek(Almanac.date(), -1);
    }

    public static Date lastMonth() {
        return Almanac.offsetMonth(Almanac.date(), -1);
    }

    public static Date lastYear() {
        return Almanac.offsetYear(Almanac.date(), -1);
    }
}

