/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.formatter;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aoju.bus.core.lang.Assert;

public abstract class FormatCache<F extends Format> {
    private static final ConcurrentMap<MultipartKey, String> C_DATE_TIME_INSTANCE_CACHE = new ConcurrentHashMap<MultipartKey, String>(7);
    private final ConcurrentMap<MultipartKey, F> cInstanceCache = new ConcurrentHashMap<MultipartKey, F>(7);

    static String getPatternForStyle(Integer dateStyle, Integer timeStyle, Locale locale) {
        MultipartKey key = new MultipartKey(dateStyle, timeStyle, locale);
        String pattern = (String)C_DATE_TIME_INSTANCE_CACHE.get(key);
        if (null == pattern) {
            try {
                DateFormat formatter = null == dateStyle ? DateFormat.getTimeInstance(timeStyle, locale) : (null == timeStyle ? DateFormat.getDateInstance(dateStyle, locale) : DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale));
                pattern = ((SimpleDateFormat)formatter).toPattern();
                String previous = C_DATE_TIME_INSTANCE_CACHE.putIfAbsent(key, pattern);
                if (null != previous) {
                    pattern = previous;
                }
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        }
        return pattern;
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public F getInstance(String pattern, TimeZone timeZone, Locale locale) {
        Format previousValue;
        MultipartKey key;
        Format format;
        Assert.notBlank(pattern, "pattern must not be blank", new Object[0]);
        if (null == timeZone) {
            timeZone = TimeZone.getDefault();
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null == (format = (Format)this.cInstanceCache.get(key = new MultipartKey(pattern, timeZone, locale))) && null != (previousValue = this.cInstanceCache.putIfAbsent(key, format = this.createInstance(pattern, timeZone, locale)))) {
            format = previousValue;
        }
        return (F)format;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    private F getDateTimeInstance(Integer dateStyle, Integer timeStyle, TimeZone timeZone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        String pattern = FormatCache.getPatternForStyle(dateStyle, timeStyle, locale);
        return this.getInstance(pattern, timeZone, locale);
    }

    F getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)dateStyle, (Integer)timeStyle, timeZone, locale);
    }

    F getDateInstance(int dateStyle, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)dateStyle, null, timeZone, locale);
    }

    F getTimeInstance(int timeStyle, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)timeStyle, timeZone, locale);
    }

    private static class MultipartKey {
        private final Object[] keys;
        private int hashCode;

        public MultipartKey(Object ... keys) {
            this.keys = keys;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (null == object) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MultipartKey other = (MultipartKey)object;
            return false != Arrays.equals(this.keys, other.keys);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int rc = 0;
                for (Object key : this.keys) {
                    if (null == key) continue;
                    rc = rc * 7 + key.hashCode();
                }
                this.hashCode = rc;
            }
            return this.hashCode;
        }
    }
}

