/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.element;

import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.lang.Scale;

public class ImageElement
extends AbstractElement<ImageElement> {
    private BufferedImage image;
    private String imgUrl;
    private Integer width;
    private Integer height;
    private Integer roundCorner;
    private Scale.Zoom zoom;
    private Integer rotate;
    private Integer blur;

    public ImageElement(String imgUrl, int x, int y) {
        this.imgUrl = imgUrl;
        this.width = this.getImage().getWidth();
        this.height = this.getImage().getHeight();
        this.zoom = Scale.Zoom.ORIGIN;
        super.setX(x);
        super.setY(y);
    }

    public ImageElement(BufferedImage image, int x, int y) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.zoom = Scale.Zoom.ORIGIN;
        super.setX(x);
        super.setY(y);
    }

    public ImageElement(String imgUrl, int x, int y, int width, int height, Scale.Zoom zoom) {
        this.imgUrl = imgUrl;
        this.width = width;
        this.height = height;
        this.zoom = zoom;
        super.setX(x);
        super.setY(y);
    }

    public ImageElement(BufferedImage image, int x, int y, int width, int height, Scale.Zoom zoom) {
        this.image = image;
        this.width = width;
        this.height = height;
        this.zoom = zoom;
        super.setX(x);
        super.setY(y);
    }

    public BufferedImage getImage() {
        if (null == this.image) {
            try {
                this.image = ImageIO.read(new URL(this.imgUrl));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.image;
    }

    public ImageElement setImage(BufferedImage image) {
        this.image = image;
        return this;
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public ImageElement setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public ImageElement setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public ImageElement setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getRoundCorner() {
        return this.roundCorner;
    }

    public ImageElement setRoundCorner(Integer roundCorner) {
        this.roundCorner = roundCorner;
        return this;
    }

    public Scale.Zoom getZoom() {
        return this.zoom;
    }

    public ImageElement setZoom(Scale.Zoom zoom) {
        this.zoom = zoom;
        return this;
    }

    public Integer getRotate() {
        return this.rotate;
    }

    public ImageElement setRotate(Integer rotate) {
        this.rotate = rotate;
        return this;
    }

    public Integer getBlur() {
        return this.blur;
    }

    public void setBlur(Integer blur) {
        this.blur = blur;
    }
}

