/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.aoju.bus.core.lang.Fonts;
import org.aoju.bus.core.toolkit.ImageKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class Graphics {
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        if (null != color) {
            g.setColor(color);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g;
    }

    public static int getCenterY(java.awt.Graphics g, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static java.awt.Graphics drawStringColourful(java.awt.Graphics g, String text, Font font, int width, int height) {
        return Graphics.drawString(g, text, font, null, width, height);
    }

    public static java.awt.Graphics drawString(java.awt.Graphics g, String text, Font font, Color color, int width, int height) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        int midY = Graphics.getCenterY(g, height);
        if (null != color) {
            g.setColor(color);
        }
        int len = text.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                g.setColor(ImageKit.randomColor());
            }
            g.drawString(String.valueOf(text.charAt(i)), i * charWidth, midY);
        }
        return g;
    }

    public static java.awt.Graphics drawString(java.awt.Graphics g, String text, Font font, Color color, Rectangle rectangle) {
        Dimension dimension;
        int backgroundWidth = rectangle.width;
        int backgroundHeight = rectangle.height;
        try {
            dimension = Fonts.getDimension(g.getFontMetrics(font), text);
        }
        catch (Exception e) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImageKit.getPointCentre(rectangle, backgroundWidth, backgroundHeight);
        return Graphics.drawString(g, text, font, color, point);
    }

    public static java.awt.Graphics drawString(java.awt.Graphics g, String text, Font font, Color color, Point point) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        g.setColor(ObjectKit.defaultIfNull(color, Color.BLACK));
        g.drawString(text, point.x, point.y);
        return g;
    }

    public static java.awt.Graphics drawImg(java.awt.Graphics g, Image img, Point point) {
        return Graphics.drawImg(g, img, new Rectangle(point.x, point.y, img.getWidth(null), img.getHeight(null)));
    }

    public static java.awt.Graphics drawImg(java.awt.Graphics g, Image img, Rectangle rectangle) {
        g.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        return g;
    }

    public static Graphics2D setAlpha(Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        return g;
    }
}

