/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lock;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lock.ObjWithLock;

public class SetWithLock<T>
extends ObjWithLock<Set<T>> {
    private static final long serialVersionUID = 1L;

    public SetWithLock(Set<T> set) {
        super(set);
    }

    public SetWithLock(Set<T> set, ReentrantReadWriteLock lock) {
        super(set, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)this.getObject();
            boolean bl = set.add(t);
            return bl;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)this.getObject();
            set.clear();
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)this.getObject();
            boolean bl = set.remove(t);
            return bl;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Set set = (Set)this.getObject();
            int n = set.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }
}

