/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.math;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Stack;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Formula {
    private final Stack<String> postfixStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String expression) {
        return new Formula().calculate(expression);
    }

    private static String transform(String expression) {
        expression = StringKit.cleanBlank(expression);
        expression = StringKit.removeSuffix(expression, "=");
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' && arr.length > 1 && arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')';
    }

    public double calculate(String expression) {
        this.prepare(Formula.transform(expression));
        Stack<String> resultStack = new Stack<String>();
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentOp = this.postfixStack.pop();
            if (!this.isOperator(currentOp.charAt(0))) {
                currentOp = currentOp.replace("~", "-");
                resultStack.push(currentOp);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            BigDecimal tempResult = this.calculate(firstValue, secondValue, currentOp.charAt(0));
            resultStack.push(tempResult.toString());
        }
        return Double.parseDouble((String)resultStack.pop());
    }

    private BigDecimal calculate(String firstValue, String secondValue, char currentOp) {
        return switch (currentOp) {
            case '+' -> MathKit.add(firstValue, secondValue);
            case '-' -> MathKit.sub(firstValue, secondValue);
            case '*' -> MathKit.mul(firstValue, secondValue);
            case '/' -> MathKit.div(firstValue, secondValue);
            default -> throw new IllegalStateException("Unexpected value: " + currentOp);
        };
    }

    public boolean compare(char cur, char peek) {
        int offset = 40;
        if (cur == '%') {
            cur = (char)47;
        }
        if (peek == '%') {
            peek = (char)47;
        }
        return this.operatPriority[peek - 40] >= this.operatPriority[cur - 40];
    }
}

