/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NamingCase {
    public static String toUnderlineCase(CharSequence text) {
        return NamingCase.toSymbolCase(text, '_');
    }

    public static String toKebabCase(CharSequence text) {
        return NamingCase.toSymbolCase(text, '-');
    }

    public static String toSymbolCase(CharSequence text, char symbol) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        TextBuilder sb = new TextBuilder();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character preChar = i > 0 ? Character.valueOf(text.charAt(i - 1)) : null;
                Character c2 = nextChar = i < text.length() - 1 ? Character.valueOf(text.charAt(i + 1)) : null;
                if (null != preChar) {
                    if (symbol == preChar.charValue()) {
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                            c = Character.toLowerCase(c);
                        }
                    } else if (Character.isLowerCase(preChar.charValue())) {
                        sb.append(symbol);
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue()) || CharsKit.isNumber(nextChar.charValue())) {
                            c = Character.toLowerCase(c);
                        }
                    } else if (null != nextChar && Character.isLowerCase(nextChar.charValue())) {
                        sb.append(symbol);
                        c = Character.toLowerCase(c);
                    }
                } else if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                    c = Character.toLowerCase(c);
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toPascalCase(CharSequence name) {
        return StringKit.upperFirst(NamingCase.toCamelCase(name));
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name, '_');
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        if (null == name) {
            return null;
        }
        String value = name.toString();
        if (StringKit.contains((CharSequence)value, symbol)) {
            int length = value.length();
            StringBuilder sb = new StringBuilder(length);
            boolean upperCase = false;
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c == symbol) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return value;
    }
}

