/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.map.CamelCaseLinkedMap;
import org.aoju.bus.core.map.CamelCaseMap;
import org.aoju.bus.core.map.MapBuilder;
import org.aoju.bus.core.map.MapProxy;
import org.aoju.bus.core.map.MapWrapper;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class MapKit {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapKit.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isOrder) {
        return MapKit.newHashMap(16, isOrder);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapKit.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        int initCapacity = size <= 0 ? 16 : size;
        return new ConcurrentHashMap(initCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        if (MapKit.isEmpty(map)) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (null == mapType || mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            return (Map)ReflectKit.newInstance(mapType, new Object[0]);
        }
        catch (InternalException e) {
            return new HashMap();
        }
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapKit.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapKit.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> of(Map.Entry<K, V> ... entries) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> pair : entries) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (null == array) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StringKit.format((CharSequence)"Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<K, ArrayList<Object>> resultMap = new HashMap<K, ArrayList<Object>>();
        if (CollKit.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            Set<Map.Entry<K, V>> entrySet = map.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key);
                if (null == valueList) {
                    valueList = CollKit.newArrayList(entry.getValue());
                    resultMap.put(key, valueList);
                    continue;
                }
                valueList.add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        boolean isEnd;
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapKit.isEmpty(listMap)) {
            return resultList;
        }
        int index = 0;
        do {
            isEnd = true;
            HashMap map = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollKit.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map.isEmpty()) {
                resultList.add(map);
            }
            ++index;
        } while (!isEnd);
        return resultList;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map) : new CamelCaseMap<K, V>(map);
    }

    public static Object[][] toObjectArray(Map<?, ?> map) {
        if (null == map) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapKit.join(map, separator, keyValueSeparator, false);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapKit.join(map, separator, keyValueSeparator, true);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (isIgnoreNull && (null == entry.getKey() || null == entry.getValue())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(separator);
            }
            stringBuilder.append(Convert.toString(entry.getKey())).append(keyValueSeparator).append(Convert.toString(entry.getValue()));
        }
        return stringBuilder.toString();
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapKit.join(map, separator, keyValueSeparator, false, otherParams);
    }

    public static String sortJoin(Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapKit.join(MapKit.sort(params), separator, keyValueSeparator, isIgnoreNull, otherParams);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapKit.join(map, separator, keyValueSeparator, true, otherParams);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        StringBuilder stringBuilder = StringKit.builder(new CharSequence[0]);
        boolean isFirst = true;
        if (MapKit.isNotEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                if (isIgnoreNull && (null == entry.getKey() || null == entry.getValue())) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(Convert.toString(entry.getKey())).append(keyValueSeparator).append(Convert.toString(entry.getValue()));
            }
        }
        if (ArrayKit.isNotEmpty(otherParams)) {
            for (String otherParam : otherParams) {
                stringBuilder.append(otherParam);
            }
        }
        return stringBuilder.toString();
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        if (null == map || null == editor) {
            return map;
        }
        HashMap<K, V> map2 = (HashMap<K, V>)ReflectKit.newInstanceIfPossible(map.getClass());
        if (null == map2) {
            map2 = new HashMap<K, V>(map.size(), 1.0f);
        }
        if (MapKit.isEmpty(map)) {
            return map2;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        Map<K, V> map2 = ObjectKit.clone(map);
        if (MapKit.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.accept(entry)) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        if (null == map || null == keys) {
            return map;
        }
        HashMap<K, V> map2 = (HashMap<K, V>)ReflectKit.newInstanceIfPossible(map.getClass());
        if (null == map2) {
            map2 = new HashMap<K, V>(map.size(), 1.0f);
        }
        if (MapKit.isEmpty(map)) {
            return map2;
        }
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return map2;
    }

    public static <K, V, R> Map<K, R> map(Map<K, V> map, BiFunction<K, V, R> biFunction) {
        if (null == map || null == biFunction) {
            return MapKit.newHashMap();
        }
        return map.entrySet().stream().collect(CollKit.toMap(Map.Entry::getKey, m -> biFunction.apply(m.getKey(), m.getValue()), (l, r) -> l));
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapKit.filter(map, (Map.Entry<K, V> t) -> new Map.Entry<T, T>((Map.Entry)t){
            final /* synthetic */ Map.Entry val$t;
            {
                this.val$t = entry;
            }

            @Override
            public T getKey() {
                return this.val$t.getValue();
            }

            @Override
            public T getValue() {
                return this.val$t.getKey();
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Unsupported setValue method !");
            }
        });
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        Map result = MapKit.createMap(map.getClass());
        map.forEach((key, value) -> result.put(value, key));
        return result;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapKit.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        if (null == map) {
            return null;
        }
        if (map instanceof TreeMap) {
            TreeMap result = (TreeMap)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        }
        return MapKit.newTreeMap(map, comparator);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sort(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        if (isDesc) {
            entryComparator = entryComparator.reversed();
        }
        map.entrySet().stream().sorted(entryComparator).forEachOrdered(e -> result.put(e.getKey(), (Comparable)e.getValue()));
        return result;
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.create(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapKit.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapKit.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        return MapKit.filter(map, (Map.Entry<K, V> entry) -> ArrayKit.contains(keys, entry.getKey()));
    }

    public static String getString(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, String.class);
    }

    public static Integer getInt(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Integer.class);
    }

    public static Double getDouble(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Double.class);
    }

    public static Double getDouble(Map<?, ?> map, Object key, Double defaultValue) {
        return MapKit.get(map, key, Double.class, defaultValue);
    }

    public static Float getFloat(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Float.class);
    }

    public static Float getFloat(Map<?, ?> map, Object key, Float defaultValue) {
        return MapKit.get(map, key, Float.class, defaultValue);
    }

    public static Short getShort(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Short.class);
    }

    public static Short getShort(Map<?, ?> map, Object key, Short defaultValue) {
        return MapKit.get(map, key, Short.class, defaultValue);
    }

    public static Boolean getBool(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Boolean.class);
    }

    public static Boolean getBool(Map<?, ?> map, Object key, Boolean defaultValue) {
        return MapKit.get(map, key, Boolean.class, defaultValue);
    }

    public static Character getChar(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Character.class);
    }

    public static Character getChar(Map<?, ?> map, Object key, Character defaultValue) {
        return MapKit.get(map, key, Character.class, defaultValue);
    }

    public static Long getLong(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Long.class);
    }

    public static Long getLong(Map<?, ?> map, Object key, Long defaultValue) {
        return MapKit.get(map, key, Long.class, defaultValue);
    }

    public static Date getDate(Map<?, ?> map, Object key) {
        return MapKit.get(map, key, Date.class);
    }

    public static Date getDate(Map<?, ?> map, Object key, Date defaultValue) {
        return MapKit.get(map, key, Date.class, defaultValue);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type) {
        return null == map ? null : (T)Convert.convert(type, map.get(key));
    }

    public static <T> T get(Map<?, ?> map, Object key, Types<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convert(type, map.get(key), defaultValue);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convert(type, map.get(key), defaultValue);
    }

    public static <T> T getQuietly(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convertQuietly(type, map.get(key), defaultValue);
    }

    public static <T> T getQuietly(Map<?, ?> map, Object key, Types<T> type, T defaultValue) {
        return null == map ? defaultValue : Convert.convertQuietly(type, map.get(key), defaultValue);
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        if (MapKit.isNotEmpty(map) && map.containsKey(oldKey)) {
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StringKit.format((CharSequence)"The key '{}' exist !", newKey));
            }
            map.put(newKey, map.remove(oldKey));
        }
        return map;
    }

    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map) {
        if (MapKit.isEmpty(map)) {
            return map;
        }
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            if (null != entry.getValue()) continue;
            iter.remove();
        }
        return map;
    }

    public static <K, V> Map<K, V> removeAny(Map<K, V> map, K ... keys) {
        for (K key : keys) {
            map.remove(key);
        }
        return map;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> zero() {
        return new HashMap(0, 1.0f);
    }

    public static <K, V, T extends Map<K, V>> T empty(Class<?> mapClass) {
        if (null == mapClass) {
            return (T)Collections.emptyMap();
        }
        if (NavigableMap.class == mapClass) {
            return (T)Collections.emptyNavigableMap();
        }
        if (SortedMap.class == mapClass) {
            return (T)Collections.emptySortedMap();
        }
        if (Map.class == mapClass) {
            return (T)Collections.emptyMap();
        }
        throw new IllegalArgumentException(StringKit.format((CharSequence)"[{}] is not support to get empty!", mapClass));
    }

    public static void clear(Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            if (!MapKit.isNotEmpty(map)) continue;
            map.clear();
        }
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return MapKit.entry(key, value, true);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value, boolean isImmutable) {
        return isImmutable ? new AbstractMap.SimpleImmutableEntry<K, V>(key, value) : new AbstractMap.SimpleEntry<K, V>(key, value);
    }
}

